package io.sealights.onpremise.agents.plugin.surefire;

import static io.sealights.onpremise.agents.plugin.surefire.PluginsHandler.SEALIGHTS_ARG_LINE;
import static io.sealights.onpremise.agents.plugin.surefire.PluginConfiguration.ARG_LINE;

import java.util.Properties;

import io.sealights.onpremise.agents.infra.configuration.validation.ValidationResult;
import io.sealights.onpremise.agents.infra.token.TokenValueFormatter;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import lombok.experimental.UtilityClass;
import org.slf4j.Logger;

/**
 * Encapsulates logging 
 * 
 * @author AlaSchneider
 *
 */
@UtilityClass
public class PluginCfgLogger {
	
	private static final String LINE = "--------------------";
	
	/**
	 * Prints to log the validation result, if it is not empty
	 */
	static void logValidationResults(Logger log, String pluginName, ValidationResult validationResult) {
		if (!validationResult.isEmpty()) {
			logImportantInfo(log, pluginName + " validation result", 
					validationResult.toStringWarnings(), 
					validationResult.toStringErrors());
		}    	
	}
	
    static void logPluginSettings(
    		Logger log,
    		Properties properties,
    		PluginConfiguration surefireConfig,
    		PluginConfiguration failsafeConfig,
    		String token, 
    		boolean withSealights) {
		String title;
		if (withSealights) {
			title = "surefire/failsafe settings for running with sealights";
		}
		else {
			title = "surefire/failsafe settings to run without sealights";
		}
		logImportantInfo(
				log,
				title,
				surefireConfig.isEmpty() ? null : surefireConfig.toString(), 
				failsafeConfig.isEmpty() ? null : failsafeConfig.toString(), 
				toStringPropertyInfo(properties, token, ARG_LINE),
				toStringPropertyInfo(properties, token, SEALIGHTS_ARG_LINE));
	}
	
    static void logImportantInfo(Logger log, String title, String... msgs) {
    	log.info("{} {}: ", LINE, title);
    	for (String ms : msgs) {
    		if (StringUtils.isNotEmpty(ms)) {
    			log.info(ms);
    		}
    	}
    	log.info(LINE + LINE + LINE);    	
    }
    
    static private String toStringPropertyInfo(Properties properties, String token, String propKey) {
    	String propValue = properties.getProperty(propKey);
    	if (StringUtils.isNotEmpty(propValue)) {
    		return String.format("property '%s'='%s'", 
    				propKey, TokenValueFormatter.truncateTokenSysProperty(propValue, token));
    	}
    	return null;
    }
    
}