package io.sealights.onpremise.agents.plugin.surefire;

import static io.sealights.onpremise.agents.plugin.surefire.PluginConfiguration.ARG_LINE;
import static io.sealights.onpremise.agents.plugin.surefire.PluginConfiguration.FORK_COUNT;
import static io.sealights.onpremise.agents.plugin.surefire.PluginConfiguration.FORK_MODE;
import static io.sealights.onpremise.agents.plugin.surefire.PluginConfiguration.PARALLEL;
import static io.sealights.onpremise.agents.plugin.surefire.PluginConfiguration.REUSE_FORKS;
import static io.sealights.onpremise.agents.plugin.surefire.PluginConfiguration.THREAD_COUNT;

import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;

import lombok.experimental.UtilityClass;

@UtilityClass
public class PluginCfgParser {
 	
	/**
	 * Looks for selected arguments of surefire/failsafe plugin configuration
	 * and updates the provided surefireConfig
	 * If exception happens on attempt to retrieve some of the values, 
	 * a partial result will be collected
	 * Note: if the surefire plugin is not defined explicitly in pom, the maven uses the default
	 * version 2.12.4, which does not support 'configuration; element in pom
	 */
	public static PluginConfiguration parse(Plugin plugin, PluginConfiguration pluginConfig) {
		if (hasConfiguration(plugin)) {
			pluginConfig.setArgLine(extractStringValue(plugin, ARG_LINE));
			pluginConfig.setReuseForks(extractBooleanValue(plugin, REUSE_FORKS));
			pluginConfig.setForkCount(extractIntegerValue(plugin, FORK_COUNT));
			pluginConfig.setThreadCount(extractIntegerValue(plugin, THREAD_COUNT));
			pluginConfig.setForkMode(extractStringValue(plugin, FORK_MODE));
			pluginConfig.setParallel(extractStringValue(plugin, PARALLEL));
		}
		return pluginConfig;
	}
	
	private boolean hasConfiguration(Plugin plugin) {
		return plugin.getConfiguration() != null;
	}
	
    private static Boolean extractBooleanValue(Plugin plugin, String name) {
		String rawValue = extractStringValue(plugin, name);
		return rawValue != null ? Boolean.parseBoolean(rawValue) : null;
    }
    
    private static Integer extractIntegerValue(Plugin plugin, String name) {
		String rawValue = extractStringValue(plugin, name);
		return rawValue != null ? Integer.parseInt(rawValue) : null;
    }
    
    private static String extractStringValue(Plugin plugin, String name) {
		Xpp3Dom cfg = (Xpp3Dom) plugin.getConfiguration();
		Xpp3Dom[] values = cfg.getChildren(name);
		if (values != null && values.length > 0) {
			return values[0].getValue();
		}
		else {
			return null;
		}
    }

}