/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import io.searchbox.action.AbstractAction;
import io.searchbox.action.BulkableAction;
import io.searchbox.action.GenericResultAbstractAction;
import io.searchbox.params.Parameters;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bulk
extends GenericResultAbstractAction {
    static final Logger log = LoggerFactory.getLogger(Bulk.class);
    protected Collection<BulkableAction> bulkableActions;

    public Bulk(Builder builder) {
        super(builder);
        this.indexName = builder.defaultIndex;
        this.typeName = builder.defaultType;
        this.bulkableActions = builder.actions;
        this.setURI(this.buildURI());
    }

    private Object getJson(Gson gson, Object source) {
        if (source instanceof String) {
            return source;
        }
        return gson.toJson(source);
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    @Override
    public String getData(Gson gson) {
        StringBuilder sb = new StringBuilder();
        for (BulkableAction action : this.bulkableActions) {
            HashMap opMap = new HashMap(1);
            HashMap<String, String> opDetails = new HashMap<String, String>(3);
            if (StringUtils.isNotBlank((CharSequence)action.getIndex())) {
                opDetails.put("_index", action.getIndex());
            }
            if (StringUtils.isNotBlank((CharSequence)action.getType())) {
                opDetails.put("_type", action.getType());
            }
            if (StringUtils.isNotBlank((CharSequence)action.getId())) {
                opDetails.put("_id", action.getId());
            }
            for (String parameter : Parameters.ACCEPTED_IN_BULK) {
                try {
                    Collection<Object> values = action.getParameter(parameter);
                    if (values == null) continue;
                    if (values.size() == 1) {
                        opDetails.put("_" + parameter, values.iterator().next().toString());
                        continue;
                    }
                    if (values.size() <= 1) continue;
                    throw new IllegalArgumentException("Expecting a single value for '" + parameter + "' parameter, you provided: " + values.size());
                }
                catch (NullPointerException e) {
                    log.debug("Could not retrieve '" + parameter + "' parameter from action.", (Throwable)e);
                }
            }
            opMap.put(action.getBulkMethodName(), opDetails);
            sb.append(gson.toJson(opMap, new TypeToken<Map<String, Map<String, String>>>(){}.getType()));
            sb.append("\n");
            String source = action.getData(gson);
            if (source == null) continue;
            sb.append(this.getJson(gson, source));
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public String getPathToResult() {
        return "ok";
    }

    @Override
    protected String buildURI() {
        StringBuilder sb = new StringBuilder(super.buildURI());
        sb.append("/_bulk");
        return sb.toString();
    }

    public static class Builder
    extends AbstractAction.Builder<Bulk, Builder> {
        private List<BulkableAction> actions = new LinkedList<BulkableAction>();
        private String defaultIndex;
        private String defaultType;

        public Builder defaultIndex(String defaultIndex) {
            this.defaultIndex = defaultIndex;
            return this;
        }

        public Builder defaultType(String defaultType) {
            this.defaultType = defaultType;
            return this;
        }

        public Builder addAction(BulkableAction action) {
            this.actions.add(action);
            return this;
        }

        public Builder addAction(Collection<? extends BulkableAction> actions) {
            this.actions.addAll(actions);
            return this;
        }

        @Override
        public Bulk build() {
            return new Bulk(this);
        }
    }
}

