/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.client.JestResult;
import io.searchbox.core.search.aggregation.MetricAggregation;
import io.searchbox.core.search.aggregation.RootAggregation;
import io.searchbox.core.search.facet.Facet;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SearchResult
extends JestResult {
    public static final String EXPLANATION_KEY = "_explanation";
    public static final String HIGHLIGHT_KEY = "highlight";
    public static final String SORT_KEY = "sort";
    public static final String[] PATH_TO_TOTAL = "hits/total".split("/");
    public static final String[] PATH_TO_MAX_SCORE = "hits/max_score".split("/");

    public SearchResult(SearchResult searchResult) {
        super(searchResult);
    }

    public SearchResult(Gson gson) {
        super(gson);
    }

    @Override
    @Deprecated
    public <T> T getSourceAsObject(Class<T> clazz) {
        return super.getSourceAsObject(clazz);
    }

    @Override
    @Deprecated
    public <T> List<T> getSourceAsObjectList(Class<T> type) {
        return super.getSourceAsObjectList(type);
    }

    public <T> Hit<T, Void> getFirstHit(Class<T> sourceType) {
        return this.getFirstHit(sourceType, Void.class);
    }

    public <T, K> Hit<T, K> getFirstHit(Class<T> sourceType, Class<K> explanationType) {
        Hit<T, K> hit = null;
        List<Hit<T, K>> hits = this.getHits(sourceType, explanationType, true);
        if (!hits.isEmpty()) {
            hit = hits.get(0);
        }
        return hit;
    }

    public <T> List<Hit<T, Void>> getHits(Class<T> sourceType) {
        return this.getHits(sourceType, Void.class);
    }

    public <T, K> List<Hit<T, K>> getHits(Class<T> sourceType, Class<K> explanationType) {
        return this.getHits(sourceType, explanationType, false);
    }

    protected <T, K> List<Hit<T, K>> getHits(Class<T> sourceType, Class<K> explanationType, boolean returnSingle) {
        String[] keys;
        ArrayList<Hit<T, K>> sourceList = new ArrayList<Hit<T, K>>();
        if (this.jsonObject != null && (keys = this.getKeys()) != null) {
            String sourceKey = keys[keys.length - 1];
            JsonElement obj = this.jsonObject.get(keys[0]);
            for (int i = 1; i < keys.length - 1; ++i) {
                obj = ((JsonObject)obj).get(keys[i]);
            }
            if (obj.isJsonObject()) {
                sourceList.add(this.extractHit(sourceType, explanationType, obj, sourceKey));
            } else if (obj.isJsonArray()) {
                for (JsonElement hitElement : obj.getAsJsonArray()) {
                    sourceList.add(this.extractHit(sourceType, explanationType, hitElement, sourceKey));
                    if (!returnSingle) continue;
                    break;
                }
            }
        }
        return sourceList;
    }

    protected <T, K> Hit<T, K> extractHit(Class<T> sourceType, Class<K> explanationType, JsonElement hitElement, String sourceKey) {
        JsonObject hitObject;
        JsonObject source;
        Hit<T, K> hit = null;
        if (hitElement.isJsonObject() && (source = (hitObject = hitElement.getAsJsonObject()).getAsJsonObject(sourceKey)) != null) {
            JsonElement id = hitObject.get("_id");
            String index = hitObject.get("_index").getAsString();
            String type = hitObject.get("_type").getAsString();
            Double score = null;
            if (hitObject.has("_score") && !hitObject.get("_score").isJsonNull()) {
                score = hitObject.get("_score").getAsDouble();
            }
            JsonElement explanation = hitObject.get(EXPLANATION_KEY);
            Map<String, List<String>> highlight = this.extractHighlight(hitObject.getAsJsonObject(HIGHLIGHT_KEY));
            List<String> sort = this.extractSort(hitObject.getAsJsonArray(SORT_KEY));
            if (id != null) {
                source.add("es_metadata_id", id);
            }
            hit = new Hit<T, K>(sourceType, (JsonElement)source, explanationType, explanation, highlight, sort, index, type, score);
        }
        return hit;
    }

    protected List<String> extractSort(JsonArray sort) {
        if (sort == null) {
            return null;
        }
        ArrayList<String> retval = new ArrayList<String>(sort.size());
        for (JsonElement sortValue : sort) {
            retval.add(sortValue.isJsonNull() ? "" : sortValue.getAsString());
        }
        return retval;
    }

    protected Map<String, List<String>> extractHighlight(JsonObject highlight) {
        HashMap retval = null;
        if (highlight != null) {
            Set highlightSet = highlight.entrySet();
            retval = new HashMap(highlightSet.size());
            for (Map.Entry entry : highlightSet) {
                ArrayList<String> fragments = new ArrayList<String>();
                for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    fragments.add(element.getAsString());
                }
                retval.put(entry.getKey(), fragments);
            }
        }
        return retval;
    }

    public Integer getTotal() {
        Integer total = null;
        JsonElement obj = this.getPath(PATH_TO_TOTAL);
        if (obj != null) {
            total = obj.getAsInt();
        }
        return total;
    }

    public Float getMaxScore() {
        Float maxScore = null;
        JsonElement obj = this.getPath(PATH_TO_MAX_SCORE);
        if (obj != null) {
            maxScore = Float.valueOf(obj.getAsFloat());
        }
        return maxScore;
    }

    protected JsonElement getPath(String[] path) {
        JsonObject retval = null;
        if (this.jsonObject != null) {
            JsonObject obj = this.jsonObject;
            for (String component : path) {
                if (obj == null) break;
                obj = obj.get(component);
            }
            retval = obj;
        }
        return retval;
    }

    public <T extends Facet> List<T> getFacets(Class<T> type) {
        ArrayList<Facet> facets = new ArrayList<Facet>();
        if (this.jsonObject != null) {
            try {
                JsonObject facetsMap = (JsonObject)this.jsonObject.get("facets");
                if (facetsMap == null) {
                    return facets;
                }
                for (Map.Entry facetEntry : facetsMap.entrySet()) {
                    JsonObject facet = ((JsonElement)facetEntry.getValue()).getAsJsonObject();
                    if (!facet.get("_type").getAsString().equalsIgnoreCase(type.getField("TYPE").get(null).toString())) continue;
                    Constructor<T> c = type.getConstructor(String.class, JsonObject.class);
                    facets.add((Facet)c.newInstance(facetEntry.getKey(), facetEntry.getValue()));
                }
                return facets;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return facets;
    }

    public MetricAggregation getAggregations() {
        String rootAggrgationName = "aggs";
        if (this.jsonObject == null) {
            return new RootAggregation("aggs", new JsonObject());
        }
        if (this.jsonObject.has("aggregations")) {
            return new RootAggregation("aggs", this.jsonObject.getAsJsonObject("aggregations"));
        }
        if (this.jsonObject.has("aggs")) {
            return new RootAggregation("aggs", this.jsonObject.getAsJsonObject("aggs"));
        }
        return new RootAggregation("aggs", new JsonObject());
    }

    public class Hit<T, K> {
        public final T source;
        public final K explanation;
        public final Map<String, List<String>> highlight;
        public final List<String> sort;
        public final String index;
        public final String type;
        public final Double score;

        public Hit(Class<T> sourceType, JsonElement source) {
            this(sourceType, source, (Class<K>)null, (JsonElement)null);
        }

        public Hit(Class<T> sourceType, JsonElement source, Class<K> explanationType, JsonElement explanation) {
            this(sourceType, source, explanationType, explanation, null, null);
        }

        public Hit(Class<T> sourceType, JsonElement source, Class<K> explanationType, JsonElement explanation, Map<String, List<String>> highlight, List<String> sort) {
            this(sourceType, source, explanationType, explanation, highlight, sort, null, null, null);
        }

        public Hit(Class<T> sourceType, JsonElement source, Class<K> explanationType, JsonElement explanation, Map<String, List<String>> highlight, List<String> sort, String index, String type, Double score) {
            this.source = source == null ? null : SearchResult.this.createSourceObject(source, sourceType);
            this.explanation = explanation == null ? null : SearchResult.this.createSourceObject(explanation, explanationType);
            this.highlight = highlight;
            this.sort = sort;
            this.index = index;
            this.type = type;
            this.score = score;
        }

        public Hit(T source) {
            this(source, null, null, null);
        }

        public Hit(T source, K explanation) {
            this(source, explanation, null, null);
        }

        public Hit(T source, K explanation, Map<String, List<String>> highlight, List<String> sort) {
            this(source, explanation, highlight, sort, null, null, null);
        }

        public Hit(T source, K explanation, Map<String, List<String>> highlight, List<String> sort, String index, String type, Double score) {
            this.source = source;
            this.explanation = explanation;
            this.highlight = highlight;
            this.sort = sort;
            this.index = index;
            this.type = type;
            this.score = score;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.source).append(this.explanation).append(this.highlight).append(this.sort).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Hit rhs = (Hit)obj;
            return new EqualsBuilder().append(this.source, rhs.source).append(this.explanation, rhs.explanation).append(this.highlight, rhs.highlight).append(this.sort, rhs.sort).isEquals();
        }
    }
}

