/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client.http;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import io.searchbox.action.Action;
import io.searchbox.client.AbstractJestClient;
import io.searchbox.client.JestResult;
import io.searchbox.client.JestResultHandler;
import io.searchbox.client.config.exception.CouldNotConnectException;
import io.searchbox.client.http.apache.HttpDeleteWithEntity;
import io.searchbox.client.http.apache.HttpGetWithEntity;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JestHttpClient
extends AbstractJestClient {
    private static final Logger log = LoggerFactory.getLogger(JestHttpClient.class);
    protected ContentType requestContentType = ContentType.APPLICATION_JSON.withCharset("utf-8");
    private CloseableHttpClient httpClient;
    private CloseableHttpAsyncClient asyncClient;
    private HttpClientContext httpClientContextTemplate;

    public <T extends JestResult> T execute(Action<T> clientRequest) throws IOException {
        return this.execute(clientRequest, null);
    }

    public <T extends JestResult> T execute(Action<T> clientRequest, RequestConfig requestConfig) throws IOException {
        HttpUriRequest request = this.prepareRequest(clientRequest, requestConfig);
        CloseableHttpResponse response = null;
        try {
            response = this.executeRequest(request);
            T t = this.deserializeResponse((HttpResponse)response, (HttpRequest)request, clientRequest);
            return t;
        }
        catch (HttpHostConnectException ex) {
            throw new CouldNotConnectException(ex.getHost().toURI(), (Throwable)ex);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException ex) {
                    log.error("Exception occurred while closing response stream.", (Throwable)ex);
                }
            }
        }
    }

    public <T extends JestResult> void executeAsync(Action<T> clientRequest, JestResultHandler<? super T> resultHandler) {
        this.executeAsync(clientRequest, resultHandler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends JestResult> void executeAsync(Action<T> clientRequest, JestResultHandler<? super T> resultHandler, RequestConfig requestConfig) {
        JestHttpClient jestHttpClient = this;
        synchronized (jestHttpClient) {
            if (!this.asyncClient.isRunning()) {
                this.asyncClient.start();
            }
        }
        HttpUriRequest request = this.prepareRequest(clientRequest, requestConfig);
        this.executeAsyncRequest(clientRequest, resultHandler, request);
    }

    public void shutdownClient() {
        super.shutdownClient();
        try {
            this.asyncClient.close();
        }
        catch (IOException ex) {
            log.error("Exception occurred while shutting down the async client.", (Throwable)ex);
        }
        try {
            this.httpClient.close();
        }
        catch (IOException ex) {
            log.error("Exception occurred while shutting down the sync client.", (Throwable)ex);
        }
    }

    protected <T extends JestResult> HttpUriRequest prepareRequest(Action<T> clientRequest, RequestConfig requestConfig) {
        String elasticSearchRestUrl = this.getRequestURL(this.getNextServer(), clientRequest.getURI());
        HttpUriRequest request = this.constructHttpMethod(clientRequest.getRestMethodName(), elasticSearchRestUrl, clientRequest.getData(this.gson), requestConfig);
        log.debug("Request method={} url={}", (Object)clientRequest.getRestMethodName(), (Object)elasticSearchRestUrl);
        for (Map.Entry header : clientRequest.getHeaders().entrySet()) {
            request.addHeader((String)header.getKey(), header.getValue().toString());
        }
        return request;
    }

    protected CloseableHttpResponse executeRequest(HttpUriRequest request) throws IOException {
        if (this.httpClientContextTemplate != null) {
            return this.httpClient.execute(request, (HttpContext)this.createContextInstance());
        }
        return this.httpClient.execute(request);
    }

    protected <T extends JestResult> Future<HttpResponse> executeAsyncRequest(Action<T> clientRequest, JestResultHandler<? super T> resultHandler, HttpUriRequest request) {
        if (this.httpClientContextTemplate != null) {
            return this.asyncClient.execute(request, (HttpContext)this.createContextInstance(), new DefaultCallback<T>(clientRequest, (HttpRequest)request, resultHandler));
        }
        return this.asyncClient.execute(request, new DefaultCallback<T>(clientRequest, (HttpRequest)request, resultHandler));
    }

    protected HttpClientContext createContextInstance() {
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider(this.httpClientContextTemplate.getCredentialsProvider());
        context.setAuthCache(this.httpClientContextTemplate.getAuthCache());
        return context;
    }

    protected HttpUriRequest constructHttpMethod(String methodName, String url, String payload, RequestConfig requestConfig) {
        Object httpUriRequest = null;
        if (methodName.equalsIgnoreCase("POST")) {
            httpUriRequest = new HttpPost(url);
            log.debug("POST method created based on client request");
        } else if (methodName.equalsIgnoreCase("PUT")) {
            httpUriRequest = new HttpPut(url);
            log.debug("PUT method created based on client request");
        } else if (methodName.equalsIgnoreCase("DELETE")) {
            httpUriRequest = new HttpDeleteWithEntity(url);
            log.debug("DELETE method created based on client request");
        } else if (methodName.equalsIgnoreCase("GET")) {
            httpUriRequest = new HttpGetWithEntity(url);
            log.debug("GET method created based on client request");
        } else if (methodName.equalsIgnoreCase("HEAD")) {
            httpUriRequest = new HttpHead(url);
            log.debug("HEAD method created based on client request");
        }
        if (httpUriRequest instanceof HttpRequestBase && requestConfig != null) {
            ((HttpRequestBase)httpUriRequest).setConfig(requestConfig);
        }
        if (httpUriRequest != null && httpUriRequest instanceof HttpEntityEnclosingRequest && payload != null) {
            EntityBuilder entityBuilder = EntityBuilder.create().setText(payload).setContentType(this.requestContentType);
            if (this.isRequestCompressionEnabled()) {
                entityBuilder.gzipCompress();
            }
            ((HttpEntityEnclosingRequest)httpUriRequest).setEntity(entityBuilder.build());
        }
        return httpUriRequest;
    }

    private <T extends JestResult> T deserializeResponse(HttpResponse response, HttpRequest httpRequest, Action<T> clientRequest) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        try {
            return (T)clientRequest.createNewElasticSearchResult(response.getEntity() == null ? null : EntityUtils.toString((HttpEntity)response.getEntity()), statusLine.getStatusCode(), statusLine.getReasonPhrase(), this.gson);
        }
        catch (JsonSyntaxException e) {
            for (Header header : response.getHeaders("Content-Type")) {
                String mimeType = header.getValue();
                if (mimeType.startsWith("application/json")) continue;
                String message = "Request " + httpRequest.toString() + " yielded " + mimeType + ", should be json: " + statusLine.toString();
                throw new IOException(message, e);
            }
            throw e;
        }
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public CloseableHttpAsyncClient getAsyncClient() {
        return this.asyncClient;
    }

    public void setAsyncClient(CloseableHttpAsyncClient asyncClient) {
        this.asyncClient = asyncClient;
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    public HttpClientContext getHttpClientContextTemplate() {
        return this.httpClientContextTemplate;
    }

    public void setHttpClientContextTemplate(HttpClientContext httpClientContext) {
        this.httpClientContextTemplate = httpClientContext;
    }

    protected class DefaultCallback<T extends JestResult>
    implements FutureCallback<HttpResponse> {
        private final Action<T> clientRequest;
        private final HttpRequest request;
        private final JestResultHandler<? super T> resultHandler;

        public DefaultCallback(Action<T> clientRequest, HttpRequest request, JestResultHandler<? super T> resultHandler) {
            this.clientRequest = clientRequest;
            this.request = request;
            this.resultHandler = resultHandler;
        }

        public void completed(HttpResponse response) {
            JestResult jestResult = null;
            try {
                jestResult = JestHttpClient.this.deserializeResponse(response, this.request, this.clientRequest);
            }
            catch (Exception e) {
                this.failed(e);
            }
            catch (Throwable t) {
                this.failed(new Exception("Problem during request processing", t));
            }
            if (jestResult != null) {
                this.resultHandler.completed((Object)jestResult);
            }
        }

        public void failed(Exception ex) {
            log.error("Exception occurred during async execution.", (Throwable)ex);
            if (ex instanceof HttpHostConnectException) {
                String host = ((HttpHostConnectException)ex).getHost().toURI();
                this.resultHandler.failed((Exception)new CouldNotConnectException(host, (Throwable)ex));
                return;
            }
            this.resultHandler.failed(ex);
        }

        public void cancelled() {
            log.warn("Async execution was cancelled; this is not expected to occur under normal operation.");
        }
    }
}

