/*
 * Decompiled with CFR 0.152.
 */
package io.seata.common.exception;

public enum FrameworkErrorCode {
    ThreadPoolFull("0004", "Thread pool is full", "Please check the thread pool configuration"),
    InitSeataClientError("0008", "Seata app name or seata server group is null", "Please check your configuration"),
    NullRuleError("0010", "Services rules is null", "Please check your configuration"),
    NetConnect("0101", "Can not connect to the server", "Please check if the seata service is started. Is the network connection to the seata server normal?"),
    NetRegAppname("0102", "Register client app name failed", "Please check if the seata service is started. Is the network connection to the seata server normal?"),
    NetDisconnect("0103", "Seata connection closed", "The network is disconnected. Please check the network connection to the client or seata server."),
    NetDispatch("0104", "Dispatch error", "Network processing error. Please check the network connection to the client or seata server."),
    NetOnMessage("0105", "On message error", "Network processing error. Please check the network connection to the client or seata server."),
    getChannelError("0106", "Get channel error", "Get channel error"),
    ChannelNotWritable("0107", "Channel not writable", "Channel not writable"),
    SendHalfMessageFailed("0108", "Send half message failed", "Send half message failed"),
    ChannelIsNotWritable("0109", "Channel is not writable", "Channel is not writable"),
    NoAvailableService("0110", "No available service", "No available service"),
    InvalidConfiguration("0201", "Invalid configuration", "Invalid configuration"),
    ExceptionCaught("0318", "Exception caught", "Exception caught"),
    RegisterRM("0304", "Register RM failed", "Register RM failed"),
    UnknownAppError("10000", "Unknown error", "Internal error");

    private String errCode;
    private String errMessage;
    private String errDispose;

    private FrameworkErrorCode(String errCode, String errMessage, String errDispose) {
        this.errCode = errCode;
        this.errMessage = errMessage;
        this.errDispose = errDispose;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public String getErrMessage() {
        return this.errMessage;
    }

    public String getErrDispose() {
        return this.errDispose;
    }

    public String toString() {
        return String.format("[%s] [%s] [%s]", this.errCode, this.errMessage, this.errDispose);
    }
}

