/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config.apollo;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.google.common.collect.Lists;
import io.seata.common.exception.NotSupportYetException;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.config.AbstractConfiguration;
import io.seata.config.ConfigFuture;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ApolloConfiguration
extends AbstractConfiguration<ConfigChangeListener> {
    private static final String REGISTRY_TYPE = "apollo";
    private static final String APP_ID = "app.id";
    private static final String APOLLO_META = "apollo.meta";
    private static final Configuration FILE_CONFIG = ConfigurationFactory.FILE_INSTANCE;
    private static volatile Config config;
    private ExecutorService configOperateExecutor;
    private static final int CORE_CONFIG_OPERATE_THREAD = 1;
    private static final ConcurrentMap<String, ConfigChangeListener> LISTENER_SERVICE_MAP;
    private static final int MAX_CONFIG_OPERATE_THREAD = 2;
    private static volatile ApolloConfiguration instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ApolloConfiguration() {
        this.readyApolloConfig();
        if (null != config) return;
        Class<ApolloConfiguration> clazz = ApolloConfiguration.class;
        synchronized (ApolloConfiguration.class) {
            if (null != config) return;
            config = ConfigService.getAppConfig();
            this.configOperateExecutor = new ThreadPoolExecutor(1, 2, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("apolloConfigOperate", 2));
            config.addChangeListener(new ConfigChangeListener(){

                public void onChange(ConfigChangeEvent changeEvent) {
                    for (Map.Entry entry : LISTENER_SERVICE_MAP.entrySet()) {
                        if (!changeEvent.isChanged((String)entry.getKey())) continue;
                        ((ConfigChangeListener)entry.getValue()).onChange(changeEvent);
                    }
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApolloConfiguration getInstance() {
        if (null != instance) return instance;
        Class<ApolloConfiguration> clazz = ApolloConfiguration.class;
        synchronized (ApolloConfiguration.class) {
            if (null != instance) return instance;
            instance = new ApolloConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public String getConfig(final String dataId, final String defaultValue, long timeoutMills) {
        final ConfigFuture configFuture = new ConfigFuture(dataId, defaultValue, ConfigFuture.ConfigOperation.GET, timeoutMills);
        this.configOperateExecutor.submit(new Runnable(){

            @Override
            public void run() {
                String result = config.getProperty(dataId, defaultValue);
                configFuture.setResult(result);
            }
        });
        return (String)configFuture.get();
    }

    @Override
    public boolean putConfig(String dataId, String content, long timeoutMills) {
        throw new NotSupportYetException("not support putConfig");
    }

    @Override
    public boolean putConfigIfAbsent(String dataId, String content, long timeoutMills) {
        throw new NotSupportYetException("not support atomic operation putConfigIfAbsent");
    }

    @Override
    public boolean removeConfig(String dataId, long timeoutMills) {
        throw new NotSupportYetException("not support removeConfig");
    }

    @Override
    public void addConfigListener(String dataId, ConfigChangeListener listener) {
        LISTENER_SERVICE_MAP.put(dataId, listener);
    }

    @Override
    public void removeConfigListener(String dataId, ConfigChangeListener listener) {
        LISTENER_SERVICE_MAP.remove(dataId, listener);
    }

    @Override
    public List<ConfigChangeListener> getConfigListeners(String dataId) {
        return Lists.newArrayList(LISTENER_SERVICE_MAP.values());
    }

    private void readyApolloConfig() {
        Properties properties = System.getProperties();
        if (!properties.containsKey(APP_ID)) {
            System.setProperty(APP_ID, FILE_CONFIG.getConfig(ApolloConfiguration.getApolloAppIdFileKey()));
        }
        if (!properties.containsKey(APOLLO_META)) {
            System.setProperty(APOLLO_META, FILE_CONFIG.getConfig(ApolloConfiguration.getApolloMetaFileKey()));
        }
    }

    @Override
    public String getTypeName() {
        return REGISTRY_TYPE;
    }

    private static String getApolloMetaFileKey() {
        return "config.apollo.apollo.meta";
    }

    private static String getApolloAppIdFileKey() {
        return "config.apollo.app.id";
    }

    static {
        LISTENER_SERVICE_MAP = new ConcurrentHashMap<String, ConfigChangeListener>();
    }
}

