/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.protocol;

import io.netty.buffer.ByteBuf;
import io.seata.core.protocol.AbstractResultMessage;

public abstract class AbstractIdentifyResponse
extends AbstractResultMessage {
    private String version = "0.6.0";
    private String extraData;
    private boolean identified;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getExtraData() {
        return this.extraData;
    }

    public void setExtraData(String extraData) {
        this.extraData = extraData;
    }

    public boolean isIdentified() {
        return this.identified;
    }

    public void setIdentified(boolean identified) {
        this.identified = identified;
    }

    @Override
    public void doEncode() {
        this.byteBuffer.put(this.identified ? (byte)1 : 0);
        if (this.version != null) {
            byte[] bs = this.version.getBytes(UTF8);
            this.byteBuffer.putShort((short)bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putShort((short)0);
        }
    }

    @Override
    public boolean decode(ByteBuf in) {
        if (in.readableBytes() < 3) {
            return false;
        }
        this.identified = in.readByte() == 1;
        short len = in.readShort();
        if (len <= 0) {
            return false;
        }
        if (in.readableBytes() < len) {
            return false;
        }
        byte[] bs = new byte[len];
        in.readBytes(bs);
        this.setVersion(new String(bs, UTF8));
        return true;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("version=");
        result.append(this.version);
        result.append(",");
        result.append("extraData=");
        result.append(this.extraData);
        result.append(",");
        result.append("identified=");
        result.append(this.identified);
        result.append(",");
        result.append("resultCode=");
        result.append((Object)this.getResultCode());
        result.append(",");
        result.append("msg=");
        result.append(this.getMsg());
        return result.toString();
    }
}

