/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.protocol;

import io.netty.buffer.ByteBuf;
import io.seata.core.protocol.AbstractMessage;
import io.seata.core.protocol.MergeMessage;
import io.seata.core.protocol.MergedMessage;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergedWarpMessage
extends AbstractMessage
implements Serializable,
MergeMessage {
    private static final long serialVersionUID = -5758802337446717090L;
    public List<AbstractMessage> msgs = new ArrayList<AbstractMessage>();
    public List<Long> msgIds = new ArrayList<Long>();
    private static final Logger LOGGER = LoggerFactory.getLogger(MergedWarpMessage.class);

    @Override
    public short getTypeCode() {
        return 59;
    }

    @Override
    public byte[] encode() {
        int bufferSize = this.msgs.size() * 1024;
        ByteBuffer byteBuffer = ByteBuffer.allocate(bufferSize);
        byteBuffer.putShort((short)this.msgs.size());
        for (AbstractMessage msg : this.msgs) {
            byte[] data = msg.encode();
            byteBuffer.putShort(msg.getTypeCode());
            byteBuffer.put(data);
        }
        byteBuffer.flip();
        int length = byteBuffer.limit();
        byte[] content = new byte[length + 4];
        MergedWarpMessage.intToBytes(length, content, 0);
        byteBuffer.get(content, 4, length);
        if (this.msgs.size() > 20 && LOGGER.isDebugEnabled()) {
            LOGGER.debug("msg in one packet:" + this.msgs.size() + ",buffer size:" + content.length);
        }
        return content;
    }

    @Override
    public boolean decode(ByteBuf in) {
        if (in.readableBytes() < 4) {
            return false;
        }
        int length = in.readInt();
        if (in.readableBytes() < length) {
            return false;
        }
        byte[] buffer = new byte[length];
        in.readBytes(buffer);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        this.doDecode(byteBuffer);
        return true;
    }

    private void doDecode(ByteBuffer byteBuffer) {
        int msgNum = byteBuffer.getShort();
        for (int idx = 0; idx < msgNum; ++idx) {
            short typeCode = byteBuffer.getShort();
            MergedMessage message = MergedWarpMessage.getMergeRequestInstanceByCode(typeCode);
            message.decode(byteBuffer);
            this.msgs.add((AbstractMessage)((Object)message));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SeataMergeMessage ");
        for (AbstractMessage msg : this.msgs) {
            sb.append(msg.toString()).append("\n");
        }
        return sb.toString();
    }
}

