/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.protocol.transaction;

import io.netty.buffer.ByteBuf;
import io.seata.core.model.BranchType;
import io.seata.core.protocol.transaction.AbstractTransactionRequestToRM;
import java.nio.ByteBuffer;

public abstract class AbstractBranchEndRequest
extends AbstractTransactionRequestToRM {
    private static final long serialVersionUID = 5083828939317068713L;
    protected String xid;
    protected long branchId;
    protected BranchType branchType = BranchType.AT;
    protected String resourceId;
    protected String applicationData;

    public String getXid() {
        return this.xid;
    }

    public void setXid(String xid) {
        this.xid = xid;
    }

    public long getBranchId() {
        return this.branchId;
    }

    public void setBranchId(long branchId) {
        this.branchId = branchId;
    }

    public BranchType getBranchType() {
        return this.branchType;
    }

    public void setBranchType(BranchType branchType) {
        this.branchType = branchType;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getApplicationData() {
        return this.applicationData;
    }

    public void setApplicationData(String applicationData) {
        this.applicationData = applicationData;
    }

    @Override
    public byte[] encode() {
        byte[] bs;
        byte[] applicationDataBytes = null;
        if (this.applicationData != null && (applicationDataBytes = this.applicationData.getBytes(UTF8)).length > 512) {
            this.byteBuffer = ByteBuffer.allocate(applicationDataBytes.length + 1024);
        }
        if (this.xid != null) {
            bs = this.xid.getBytes(UTF8);
            this.byteBuffer.putShort((short)bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putShort((short)0);
        }
        this.byteBuffer.putLong(this.branchId);
        this.byteBuffer.put((byte)this.branchType.ordinal());
        if (this.resourceId != null) {
            bs = this.resourceId.getBytes(UTF8);
            this.byteBuffer.putShort((short)bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putShort((short)0);
        }
        if (this.applicationData != null) {
            this.byteBuffer.putInt(applicationDataBytes.length);
            if (applicationDataBytes.length > 0) {
                this.byteBuffer.put(applicationDataBytes);
            }
        } else {
            this.byteBuffer.putInt(0);
        }
        this.byteBuffer.flip();
        byte[] content = new byte[this.byteBuffer.limit()];
        this.byteBuffer.get(content);
        return content;
    }

    @Override
    public boolean decode(ByteBuf in) {
        int xidLen = 0;
        if (in.readableBytes() >= 2) {
            xidLen = in.readShort();
        }
        if (xidLen <= 0) {
            return false;
        }
        if (in.readableBytes() < xidLen) {
            return false;
        }
        byte[] bs = new byte[xidLen];
        in.readBytes(bs);
        this.setXid(new String(bs, UTF8));
        if (in.readableBytes() < 8) {
            return false;
        }
        this.branchId = in.readLong();
        if (in.readableBytes() < 1) {
            return false;
        }
        this.branchType = BranchType.get(in.readByte());
        short resourceIdLen = 0;
        if (in.readableBytes() < 2) {
            return false;
        }
        resourceIdLen = in.readShort();
        if (resourceIdLen <= 0) {
            return false;
        }
        if (in.readableBytes() < resourceIdLen) {
            return false;
        }
        bs = new byte[resourceIdLen];
        in.readBytes(bs);
        this.setResourceId(new String(bs, UTF8));
        int applicationDataLen = 0;
        if (in.readableBytes() < 4) {
            return false;
        }
        applicationDataLen = in.readInt();
        if (applicationDataLen > 0) {
            if (in.readableBytes() < applicationDataLen) {
                return false;
            }
            bs = new byte[applicationDataLen];
            in.readBytes(bs);
            this.setApplicationData(new String(bs, UTF8));
        }
        return true;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("xid=");
        result.append(this.xid);
        result.append(",");
        result.append("branchId=");
        result.append(this.branchId);
        result.append(",");
        result.append("branchType=");
        result.append((Object)this.branchType);
        result.append(",");
        result.append("resourceId=");
        result.append(this.resourceId);
        result.append(",");
        result.append("applicationData=");
        result.append(this.applicationData);
        return result.toString();
    }
}

