/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.seata.common.exception.FrameworkException;
import io.seata.common.util.NetUtil;
import io.seata.core.protocol.RegisterRMResponse;
import io.seata.core.protocol.RegisterTMResponse;
import io.seata.core.rpc.netty.AbstractRpcRemotingClient;
import io.seata.core.rpc.netty.NettyPoolKey;
import java.net.InetSocketAddress;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyPoolableFactory
implements KeyedPoolableObjectFactory<NettyPoolKey, Channel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyPoolableFactory.class);
    private final AbstractRpcRemotingClient rpcRemotingClient;

    public NettyPoolableFactory(AbstractRpcRemotingClient rpcRemotingClient) {
        this.rpcRemotingClient = rpcRemotingClient;
        this.rpcRemotingClient.setChannelHandlers(new ChannelHandler[]{rpcRemotingClient});
        this.rpcRemotingClient.start();
    }

    public Channel makeObject(NettyPoolKey key) throws Exception {
        InetSocketAddress address = NetUtil.toInetSocketAddress(key.getAddress());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("NettyPool create channel to " + key);
        }
        Channel tmpChannel = this.rpcRemotingClient.getNewChannel(address);
        long start = System.currentTimeMillis();
        Object response = null;
        Channel channelToServer = null;
        if (null == key.getMessage()) {
            throw new FrameworkException("register msg is null, role:" + key.getTransactionRole().name());
        }
        try {
            response = this.rpcRemotingClient.sendAsyncRequestWithResponse(null, tmpChannel, key.getMessage());
            if (!this.isResponseSuccess(response, key.getTransactionRole())) {
                this.rpcRemotingClient.onRegisterMsgFail(key.getAddress(), tmpChannel, response, key.getMessage());
            } else {
                channelToServer = tmpChannel;
                this.rpcRemotingClient.onRegisterMsgSuccess(key.getAddress(), tmpChannel, response, key.getMessage());
            }
        }
        catch (Exception exx) {
            if (tmpChannel != null) {
                tmpChannel.close();
            }
            throw new FrameworkException("register error,role:" + key.getTransactionRole().name() + ",err:" + exx.getMessage());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("register success, cost " + (System.currentTimeMillis() - start) + " ms, version:" + this.getVersion(response, key.getTransactionRole()) + ",role:" + key.getTransactionRole().name() + ",channel:" + channelToServer);
        }
        return channelToServer;
    }

    private boolean isResponseSuccess(Object response, NettyPoolKey.TransactionRole transactionRole) {
        if (null == response) {
            return false;
        }
        if (transactionRole.equals((Object)NettyPoolKey.TransactionRole.TMROLE)) {
            if (!(response instanceof RegisterTMResponse)) {
                return false;
            }
            return ((RegisterTMResponse)response).isIdentified();
        }
        if (transactionRole.equals((Object)NettyPoolKey.TransactionRole.RMROLE)) {
            if (!(response instanceof RegisterRMResponse)) {
                return false;
            }
            return ((RegisterRMResponse)response).isIdentified();
        }
        return false;
    }

    private String getVersion(Object response, NettyPoolKey.TransactionRole transactionRole) {
        if (transactionRole.equals((Object)NettyPoolKey.TransactionRole.TMROLE)) {
            return ((RegisterTMResponse)response).getVersion();
        }
        return ((RegisterRMResponse)response).getVersion();
    }

    public void destroyObject(NettyPoolKey key, Channel channel) throws Exception {
        if (null != channel) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("will destroy channel:" + channel);
            }
            channel.disconnect();
            channel.close();
        }
    }

    public boolean validateObject(NettyPoolKey key, Channel obj) {
        if (null != obj && obj.isActive()) {
            return true;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("channel valid false,channel:" + obj);
        }
        return false;
    }

    public void activateObject(NettyPoolKey key, Channel obj) throws Exception {
    }

    public void passivateObject(NettyPoolKey key, Channel obj) throws Exception {
    }
}

