/*
 * Decompiled with CFR 0.152.
 */
package io.seata.discovery.registry.nacos;

import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.Event;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.discovery.registry.RegistryService;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class NacosRegistryServiceImpl
implements RegistryService<EventListener> {
    private static final String DEFAULT_NAMESPACE = "public";
    private static final String DEFAULT_CLUSTER = "default";
    private static final String PRO_SERVER_ADDR_KEY = "serverAddr";
    private static final String PRO_NAMESPACE_KEY = "namespace";
    private static final String REGISTRY_TYPE = "nacos";
    private static final String REGISTRY_CLUSTER = "cluster";
    private static final Configuration FILE_CONFIG = ConfigurationFactory.FILE_INSTANCE;
    private static volatile NamingService naming;
    private static final ConcurrentMap<String, List<EventListener>> LISTENER_SERVICE_MAP;
    private static final ConcurrentMap<String, List<InetSocketAddress>> CLUSTER_ADDRESS_MAP;
    private static volatile NacosRegistryServiceImpl instance;

    private NacosRegistryServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static NacosRegistryServiceImpl getInstance() {
        if (null != instance) return instance;
        Class<NacosRegistryServiceImpl> clazz = NacosRegistryServiceImpl.class;
        synchronized (NacosRegistryServiceImpl.class) {
            if (null != instance) return instance;
            instance = new NacosRegistryServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void register(InetSocketAddress address) throws Exception {
        this.validAddress(address);
        NacosRegistryServiceImpl.getNamingInstance().registerInstance(PRO_SERVER_ADDR_KEY, address.getAddress().getHostAddress(), address.getPort(), NacosRegistryServiceImpl.getClusterName());
    }

    @Override
    public void unregister(InetSocketAddress address) throws Exception {
        this.validAddress(address);
        NacosRegistryServiceImpl.getNamingInstance().deregisterInstance(PRO_SERVER_ADDR_KEY, address.getAddress().getHostAddress(), address.getPort(), NacosRegistryServiceImpl.getClusterName());
    }

    @Override
    public void subscribe(String cluster, EventListener listener) throws Exception {
        ArrayList<String> clusters = new ArrayList<String>();
        clusters.add(cluster);
        LISTENER_SERVICE_MAP.putIfAbsent(cluster, new ArrayList());
        ((List)LISTENER_SERVICE_MAP.get(cluster)).add(listener);
        NacosRegistryServiceImpl.getNamingInstance().subscribe(PRO_SERVER_ADDR_KEY, clusters, listener);
    }

    @Override
    public void unsubscribe(String cluster, EventListener listener) throws Exception {
        ArrayList<String> clusters = new ArrayList<String>();
        clusters.add(cluster);
        List subscribeList = (List)LISTENER_SERVICE_MAP.get(cluster);
        if (null != subscribeList) {
            ArrayList<EventListener> newSubscribeList = new ArrayList<EventListener>();
            for (EventListener eventListener : subscribeList) {
                if (eventListener.equals(listener)) continue;
                newSubscribeList.add(eventListener);
            }
            LISTENER_SERVICE_MAP.put(cluster, newSubscribeList);
        }
        NacosRegistryServiceImpl.getNamingInstance().unsubscribe(PRO_SERVER_ADDR_KEY, clusters, listener);
    }

    @Override
    public List<InetSocketAddress> lookup(String key) throws Exception {
        Configuration config = ConfigurationFactory.getInstance();
        final String clusterName = config.getConfig("service.vgroup_mapping." + key);
        if (null == clusterName) {
            return null;
        }
        if (!LISTENER_SERVICE_MAP.containsKey(clusterName)) {
            ArrayList<String> clusters = new ArrayList<String>();
            clusters.add(clusterName);
            List firstAllInstances = NacosRegistryServiceImpl.getNamingInstance().getAllInstances(PRO_SERVER_ADDR_KEY, clusters);
            if (null != firstAllInstances) {
                ArrayList<InetSocketAddress> newAddressList = new ArrayList<InetSocketAddress>();
                for (Instance instance : firstAllInstances) {
                    if (!instance.isEnabled() || !instance.isHealthy()) continue;
                    newAddressList.add(new InetSocketAddress(instance.getIp(), instance.getPort()));
                }
                CLUSTER_ADDRESS_MAP.put(clusterName, newAddressList);
            }
            this.subscribe(clusterName, new EventListener(){

                public void onEvent(Event event) {
                    List instances = ((NamingEvent)event).getInstances();
                    if (null == instances && null != CLUSTER_ADDRESS_MAP.get(clusterName)) {
                        CLUSTER_ADDRESS_MAP.remove(clusterName);
                    } else if (!CollectionUtils.isEmpty((Collection)instances)) {
                        ArrayList<InetSocketAddress> newAddressList = new ArrayList<InetSocketAddress>();
                        for (Instance instance : instances) {
                            if (!instance.isEnabled() || !instance.isHealthy()) continue;
                            newAddressList.add(new InetSocketAddress(instance.getIp(), instance.getPort()));
                        }
                        CLUSTER_ADDRESS_MAP.put(clusterName, newAddressList);
                    }
                }
            });
        }
        return (List)CLUSTER_ADDRESS_MAP.get(clusterName);
    }

    @Override
    public void close() throws Exception {
    }

    private void validAddress(InetSocketAddress address) {
        if (null == address.getHostName() || 0 == address.getPort()) {
            throw new IllegalArgumentException("invalid address:" + address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NamingService getNamingInstance() throws Exception {
        if (null != naming) return naming;
        Class<NacosRegistryServiceImpl> clazz = NacosRegistryServiceImpl.class;
        synchronized (NacosRegistryServiceImpl.class) {
            if (null != naming) return naming;
            naming = NamingFactory.createNamingService((Properties)NacosRegistryServiceImpl.getNamingProperties());
            // ** MonitorExit[var0] (shouldn't be in output)
            return naming;
        }
    }

    private static Properties getNamingProperties() {
        Properties properties = new Properties();
        if (null != System.getProperty(PRO_SERVER_ADDR_KEY)) {
            properties.setProperty(PRO_SERVER_ADDR_KEY, System.getProperty(PRO_SERVER_ADDR_KEY));
        } else {
            String address = FILE_CONFIG.getConfig(NacosRegistryServiceImpl.getNacosAddrFileKey());
            if (null != address) {
                properties.setProperty(PRO_SERVER_ADDR_KEY, address);
            }
        }
        if (null != System.getProperty(PRO_NAMESPACE_KEY)) {
            properties.setProperty(PRO_NAMESPACE_KEY, System.getProperty(PRO_NAMESPACE_KEY));
        } else {
            String namespace = FILE_CONFIG.getConfig(NacosRegistryServiceImpl.getNacosNameSpaceFileKey());
            if (null == namespace) {
                namespace = DEFAULT_NAMESPACE;
            }
            properties.setProperty(PRO_NAMESPACE_KEY, namespace);
        }
        return properties;
    }

    private static String getClusterName() {
        String cluster = FILE_CONFIG.getConfig(NacosRegistryServiceImpl.getNacosClusterFileKey());
        if (null == cluster) {
            cluster = DEFAULT_CLUSTER;
        }
        return cluster;
    }

    private static String getNacosAddrFileKey() {
        return "registry.nacos.serverAddr";
    }

    private static String getNacosNameSpaceFileKey() {
        return "registry.nacos.namespace";
    }

    private static String getNacosClusterFileKey() {
        return "registry.nacos.cluster";
    }

    static {
        LISTENER_SERVICE_MAP = new ConcurrentHashMap<String, List<EventListener>>();
        CLUSTER_ADDRESS_MAP = new ConcurrentHashMap<String, List<InetSocketAddress>>();
    }
}

