/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.sql.druid;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import io.seata.rm.datasource.ParametersHolder;
import io.seata.rm.datasource.sql.SQLParsingException;
import io.seata.rm.datasource.sql.SQLType;
import io.seata.rm.datasource.sql.SQLUpdateRecognizer;
import io.seata.rm.datasource.sql.druid.BaseRecognizer;
import java.util.ArrayList;
import java.util.List;

public class MySQLUpdateRecognizer
extends BaseRecognizer
implements SQLUpdateRecognizer {
    private MySqlUpdateStatement ast;

    public MySQLUpdateRecognizer(String originalSQL, SQLStatement ast) {
        super(originalSQL);
        this.ast = (MySqlUpdateStatement)ast;
    }

    @Override
    public SQLType getSQLType() {
        return SQLType.UPDATE;
    }

    @Override
    public List<String> getUpdateColumns() {
        List updateSetItems = this.ast.getItems();
        ArrayList<String> list = new ArrayList<String>(updateSetItems.size());
        for (SQLUpdateSetItem updateSetItem : updateSetItems) {
            SQLExpr expr = updateSetItem.getColumn();
            if (expr instanceof SQLIdentifierExpr) {
                list.add(((SQLIdentifierExpr)expr).getName());
                continue;
            }
            if (expr instanceof SQLPropertyExpr) {
                SQLExpr owner = ((SQLPropertyExpr)expr).getOwner();
                if (!(owner instanceof SQLIdentifierExpr)) continue;
                list.add(((SQLIdentifierExpr)owner).getName() + "." + ((SQLPropertyExpr)expr).getName());
                continue;
            }
            throw new SQLParsingException("Unknown SQLExpr: " + expr.getClass() + " " + expr);
        }
        return list;
    }

    @Override
    public List<Object> getUpdateValues() {
        List updateSetItems = this.ast.getItems();
        ArrayList<Object> list = new ArrayList<Object>(updateSetItems.size());
        for (SQLUpdateSetItem updateSetItem : updateSetItems) {
            SQLExpr expr = updateSetItem.getValue();
            if (expr instanceof SQLValuableExpr) {
                list.add(((SQLValuableExpr)expr).getValue());
                continue;
            }
            if (expr instanceof SQLVariantRefExpr) {
                list.add(new BaseRecognizer.VMarker());
                continue;
            }
            throw new SQLParsingException("Unknown SQLExpr: " + expr.getClass() + " " + expr);
        }
        return list;
    }

    @Override
    public String getWhereCondition(final ParametersHolder parametersHolder, final ArrayList<Object> paramAppender) {
        SQLExpr where = this.ast.getWhere();
        if (where == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        MySqlOutputVisitor visitor = new MySqlOutputVisitor(sb){

            public boolean visit(SQLVariantRefExpr x) {
                if ("?".equals(x.getName())) {
                    ArrayList<Object> params = parametersHolder.getParameters()[x.getIndex()];
                    paramAppender.add(params.get(0));
                }
                return super.visit(x);
            }
        };
        if (where instanceof SQLBinaryOpExpr) {
            visitor.visit((SQLBinaryOpExpr)where);
        } else if (where instanceof SQLInListExpr) {
            visitor.visit((SQLInListExpr)where);
        } else if (where instanceof SQLBetweenExpr) {
            visitor.visit((SQLBetweenExpr)where);
        } else {
            throw new IllegalArgumentException("unexpected WHERE expr: " + where.getClass().getSimpleName());
        }
        return sb.toString();
    }

    @Override
    public String getWhereCondition() {
        SQLExpr where = this.ast.getWhere();
        if (where == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        MySqlOutputVisitor visitor = new MySqlOutputVisitor((Appendable)sb);
        if (where instanceof SQLBetweenExpr) {
            visitor.visit((SQLBetweenExpr)where);
        } else if (where instanceof SQLInListExpr) {
            visitor.visit((SQLInListExpr)where);
        } else {
            visitor.visit((SQLBinaryOpExpr)where);
        }
        return sb.toString();
    }

    @Override
    public String getTableAlias() {
        return this.ast.getTableSource().getAlias();
    }

    @Override
    public String getTableName() {
        StringBuffer sb = new StringBuffer();
        MySqlOutputVisitor visitor = new MySqlOutputVisitor(sb){

            public boolean visit(SQLExprTableSource x) {
                this.printTableSourceExpr(x.getExpr());
                return false;
            }
        };
        SQLExprTableSource tableSource = (SQLExprTableSource)this.ast.getTableSource();
        visitor.visit(tableSource);
        return sb.toString();
    }
}

