/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.seata.common.Constants;
import io.seata.core.protocol.MergeResultMessage;
import io.seata.core.protocol.MergedMessage;
import io.seata.core.protocol.MergedWarpMessage;
import io.seata.core.protocol.MessageCodec;
import io.seata.core.protocol.RegisterRMRequest;
import io.seata.core.protocol.RegisterRMResponse;
import io.seata.core.protocol.RegisterTMRequest;
import io.seata.core.protocol.RegisterTMResponse;
import io.seata.core.protocol.transaction.BranchCommitRequest;
import io.seata.core.protocol.transaction.BranchCommitResponse;
import io.seata.core.protocol.transaction.BranchRegisterRequest;
import io.seata.core.protocol.transaction.BranchRegisterResponse;
import io.seata.core.protocol.transaction.BranchReportRequest;
import io.seata.core.protocol.transaction.BranchReportResponse;
import io.seata.core.protocol.transaction.BranchRollbackRequest;
import io.seata.core.protocol.transaction.BranchRollbackResponse;
import io.seata.core.protocol.transaction.GlobalBeginRequest;
import io.seata.core.protocol.transaction.GlobalBeginResponse;
import io.seata.core.protocol.transaction.GlobalCommitRequest;
import io.seata.core.protocol.transaction.GlobalCommitResponse;
import io.seata.core.protocol.transaction.GlobalLockQueryRequest;
import io.seata.core.protocol.transaction.GlobalLockQueryResponse;
import io.seata.core.protocol.transaction.GlobalRollbackRequest;
import io.seata.core.protocol.transaction.GlobalRollbackResponse;
import io.seata.core.protocol.transaction.GlobalStatusRequest;
import io.seata.core.protocol.transaction.GlobalStatusResponse;
import java.io.Serializable;
import java.nio.charset.Charset;

public abstract class AbstractMessage
implements MessageCodec,
Serializable {
    private static final long serialVersionUID = -1441020418526899889L;
    public static final short TYPE_GLOBAL_BEGIN = 1;
    public static final short TYPE_GLOBAL_BEGIN_RESULT = 2;
    public static final short TYPE_GLOBAL_COMMIT = 7;
    public static final short TYPE_GLOBAL_COMMIT_RESULT = 8;
    public static final short TYPE_GLOBAL_ROLLBACK = 9;
    public static final short TYPE_GLOBAL_ROLLBACK_RESULT = 10;
    public static final short TYPE_GLOBAL_STATUS = 15;
    public static final short TYPE_GLOBAL_STATUS_RESULT = 16;
    public static final short TYPE_GLOBAL_LOCK_QUERY = 21;
    public static final short TYPE_GLOBAL_LOCK_QUERY_RESULT = 22;
    public static final short TYPE_BRANCH_COMMIT = 3;
    public static final short TYPE_BRANCH_COMMIT_RESULT = 4;
    public static final short TYPE_BRANCH_ROLLBACK = 5;
    public static final short TYPE_BRANCH_ROLLBACK_RESULT = 6;
    public static final short TYPE_BRANCH_REGISTER = 11;
    public static final short TYPE_BRANCH_REGISTER_RESULT = 12;
    public static final short TYPE_BRANCH_STATUS_REPORT = 13;
    public static final short TYPE_BRANCH_STATUS_REPORT_RESULT = 14;
    public static final short TYPE_SEATA_MERGE = 59;
    public static final short TYPE_SEATA_MERGE_RESULT = 60;
    public static final short TYPE_REG_CLT = 101;
    public static final short TYPE_REG_CLT_RESULT = 102;
    public static final short TYPE_REG_RM = 103;
    public static final short TYPE_REG_RM_RESULT = 104;
    protected static final Charset UTF8 = Constants.DEFAULT_CHARSET;
    protected ChannelHandlerContext ctx;

    public static int bytesToInt(byte[] bytes, int offset) {
        int ret = 0;
        for (int i = 0; i < 4 && i + offset < bytes.length; ++i) {
            ret <<= 8;
            ret |= bytes[i + offset] & 0xFF;
        }
        return ret;
    }

    public static void intToBytes(int i, byte[] bytes, int offset) {
        bytes[offset] = (byte)(i >> 24 & 0xFF);
        bytes[offset + 1] = (byte)(i >> 16 & 0xFF);
        bytes[offset + 2] = (byte)(i >> 8 & 0xFF);
        bytes[offset + 3] = (byte)(i & 0xFF);
    }

    @Override
    public boolean decode(ByteBuf in) {
        return false;
    }

    public static MessageCodec getMsgInstanceByCode(short typeCode) {
        MessageCodec msgCodec = null;
        switch (typeCode) {
            case 59: {
                msgCodec = new MergedWarpMessage();
                break;
            }
            case 60: {
                msgCodec = new MergeResultMessage();
                break;
            }
            case 101: {
                msgCodec = new RegisterTMRequest();
                break;
            }
            case 102: {
                msgCodec = new RegisterTMResponse();
                break;
            }
            case 103: {
                msgCodec = new RegisterRMRequest();
                break;
            }
            case 104: {
                msgCodec = new RegisterRMResponse();
                break;
            }
            case 3: {
                msgCodec = new BranchCommitRequest();
                break;
            }
            case 5: {
                msgCodec = new BranchRollbackRequest();
                break;
            }
        }
        if (null != msgCodec) {
            return msgCodec;
        }
        try {
            msgCodec = (MessageCodec)((Object)AbstractMessage.getMergeRequestInstanceByCode(typeCode));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null != msgCodec) {
            return msgCodec;
        }
        return (MessageCodec)((Object)AbstractMessage.getMergeResponseInstanceByCode(typeCode));
    }

    public static MergedMessage getMergeRequestInstanceByCode(int typeCode) {
        switch (typeCode) {
            case 1: {
                return new GlobalBeginRequest();
            }
            case 7: {
                return new GlobalCommitRequest();
            }
            case 9: {
                return new GlobalRollbackRequest();
            }
            case 15: {
                return new GlobalStatusRequest();
            }
            case 21: {
                return new GlobalLockQueryRequest();
            }
            case 11: {
                return new BranchRegisterRequest();
            }
            case 13: {
                return new BranchReportRequest();
            }
        }
        throw new IllegalArgumentException("not support typeCode," + typeCode);
    }

    public static MergedMessage getMergeResponseInstanceByCode(int typeCode) {
        switch (typeCode) {
            case 2: {
                return new GlobalBeginResponse();
            }
            case 8: {
                return new GlobalCommitResponse();
            }
            case 10: {
                return new GlobalRollbackResponse();
            }
            case 16: {
                return new GlobalStatusResponse();
            }
            case 22: {
                return new GlobalLockQueryResponse();
            }
            case 12: {
                return new BranchRegisterResponse();
            }
            case 14: {
                return new BranchReportResponse();
            }
            case 4: {
                return new BranchCommitResponse();
            }
            case 6: {
                return new BranchRollbackResponse();
            }
        }
        throw new IllegalArgumentException("not support typeCode," + typeCode);
    }
}

