/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.protocol.transaction;

import io.seata.core.protocol.MergedMessage;
import io.seata.core.protocol.transaction.AbstractTransactionRequestToTC;
import java.nio.ByteBuffer;

public abstract class AbstractGlobalEndRequest
extends AbstractTransactionRequestToTC
implements MergedMessage {
    private String xid;
    protected String extraData;

    public String getXid() {
        return this.xid;
    }

    public void setXid(String xid) {
        this.xid = xid;
    }

    public String getExtraData() {
        return this.extraData;
    }

    public void setExtraData(String extraData) {
        this.extraData = extraData;
    }

    @Override
    public byte[] encode() {
        byte[] bs;
        ByteBuffer byteBuffer = ByteBuffer.allocate(256);
        if (this.xid != null) {
            bs = this.xid.getBytes(UTF8);
            byteBuffer.putShort((short)bs.length);
            if (bs.length > 0) {
                byteBuffer.put(bs);
            }
        } else {
            byteBuffer.putShort((short)0);
        }
        if (this.extraData != null) {
            bs = this.extraData.getBytes(UTF8);
            byteBuffer.putShort((short)bs.length);
            if (bs.length > 0) {
                byteBuffer.put(bs);
            }
        } else {
            byteBuffer.putShort((short)0);
        }
        byteBuffer.flip();
        byte[] content = new byte[byteBuffer.limit()];
        byteBuffer.get(content);
        return content;
    }

    @Override
    public void decode(ByteBuffer byteBuffer) {
        short len;
        short xidLen = byteBuffer.getShort();
        if (xidLen > 0) {
            byte[] bs = new byte[xidLen];
            byteBuffer.get(bs);
            this.setXid(new String(bs, UTF8));
        }
        if ((len = byteBuffer.getShort()) > 0) {
            byte[] bs = new byte[len];
            byteBuffer.get(bs);
            this.setExtraData(new String(bs, UTF8));
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("xid=");
        result.append(this.xid);
        result.append(",");
        result.append("extraData=");
        result.append(this.extraData);
        return result.toString();
    }
}

