/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource;

import com.alibaba.druid.util.JdbcUtils;
import io.seata.core.model.BranchType;
import io.seata.core.model.Resource;
import io.seata.rm.DefaultResourceManager;
import io.seata.rm.datasource.AbstractDataSourceProxy;
import io.seata.rm.datasource.ConnectionProxy;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DataSourceProxy
extends AbstractDataSourceProxy
implements Resource {
    private String resourceGroupId;
    private static final String DEFAULT_RESOURCE_GROUP_ID = "DEFAULT";
    private String jdbcUrl;
    private String dbType;

    public DataSourceProxy(DataSource targetDataSource) {
        this(targetDataSource, DEFAULT_RESOURCE_GROUP_ID);
    }

    public DataSourceProxy(DataSource targetDataSource, String resourceGroupId) {
        super(targetDataSource);
        this.init(targetDataSource, resourceGroupId);
    }

    private void init(DataSource dataSource, String resourceGroupId) {
        this.resourceGroupId = resourceGroupId;
        try (Connection connection = dataSource.getConnection();){
            this.jdbcUrl = connection.getMetaData().getURL();
            this.dbType = JdbcUtils.getDbType((String)this.jdbcUrl, null);
        }
        catch (SQLException e) {
            throw new IllegalStateException("can not init dataSource", e);
        }
        DefaultResourceManager.get().registerResource(this);
    }

    public Connection getPlainConnection() throws SQLException {
        return this.targetDataSource.getConnection();
    }

    public String getDbType() {
        return this.dbType;
    }

    @Override
    public ConnectionProxy getConnection() throws SQLException {
        Connection targetConnection = this.targetDataSource.getConnection();
        return new ConnectionProxy(this, targetConnection);
    }

    @Override
    public ConnectionProxy getConnection(String username, String password) throws SQLException {
        Connection targetConnection = this.targetDataSource.getConnection(username, password);
        return new ConnectionProxy(this, targetConnection);
    }

    @Override
    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    @Override
    public String getResourceId() {
        return this.jdbcUrl;
    }

    @Override
    public BranchType getBranchType() {
        return BranchType.AT;
    }
}

