/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec;

import io.seata.core.context.RootContext;
import io.seata.rm.datasource.StatementProxy;
import io.seata.rm.datasource.exec.DeleteExecutor;
import io.seata.rm.datasource.exec.Executor;
import io.seata.rm.datasource.exec.InsertExecutor;
import io.seata.rm.datasource.exec.PlainExecutor;
import io.seata.rm.datasource.exec.SelectForUpdateExecutor;
import io.seata.rm.datasource.exec.StatementCallback;
import io.seata.rm.datasource.exec.UpdateExecutor;
import io.seata.rm.datasource.sql.SQLRecognizer;
import io.seata.rm.datasource.sql.SQLVisitorFactory;
import java.sql.SQLException;
import java.sql.Statement;

public class ExecuteTemplate {
    public static <T, S extends Statement> T execute(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, Object ... args) throws SQLException {
        return ExecuteTemplate.execute(null, statementProxy, statementCallback, args);
    }

    public static <T, S extends Statement> T execute(SQLRecognizer sqlRecognizer, StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, Object ... args) throws SQLException {
        if (!RootContext.inGlobalTransaction() && !RootContext.requireGlobalLock()) {
            return statementCallback.execute(statementProxy.getTargetStatement(), args);
        }
        if (sqlRecognizer == null) {
            sqlRecognizer = SQLVisitorFactory.get(statementProxy.getTargetSQL(), statementProxy.getConnectionProxy().getDbType());
        }
        Executor executor = null;
        if (sqlRecognizer == null) {
            executor = new PlainExecutor<T, S>(statementProxy, statementCallback);
        } else {
            switch (sqlRecognizer.getSQLType()) {
                case INSERT: {
                    executor = new InsertExecutor((StatementProxy)statementProxy, statementCallback, sqlRecognizer);
                    break;
                }
                case UPDATE: {
                    executor = new UpdateExecutor((StatementProxy)statementProxy, statementCallback, sqlRecognizer);
                    break;
                }
                case DELETE: {
                    executor = new DeleteExecutor((StatementProxy)statementProxy, statementCallback, sqlRecognizer);
                    break;
                }
                case SELECT_FOR_UPDATE: {
                    executor = new SelectForUpdateExecutor<T, S>(statementProxy, statementCallback, sqlRecognizer);
                    break;
                }
                default: {
                    executor = new PlainExecutor<T, S>(statementProxy, statementCallback);
                }
            }
        }
        T rs = null;
        try {
            rs = executor.execute(args);
        }
        catch (Throwable ex2) {
            SQLException ex2;
            if (!(ex2 instanceof SQLException)) {
                ex2 = new SQLException(ex2);
            }
            throw (SQLException)ex2;
        }
        return rs;
    }
}

