/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.sql;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import io.seata.rm.datasource.sql.SQLRecognizer;
import io.seata.rm.datasource.sql.druid.BaseRecognizer;
import io.seata.rm.datasource.sql.druid.MySQLDeleteRecognizer;
import io.seata.rm.datasource.sql.druid.MySQLInsertRecognizer;
import io.seata.rm.datasource.sql.druid.MySQLSelectForUpdateRecognizer;
import io.seata.rm.datasource.sql.druid.MySQLUpdateRecognizer;
import java.util.List;

public class SQLVisitorFactory {
    public static SQLRecognizer get(String sql, String dbType) {
        List asts = SQLUtils.parseStatements((String)sql, (String)dbType);
        if (asts == null || asts.size() != 1) {
            throw new UnsupportedOperationException("Unsupported SQL: " + sql);
        }
        BaseRecognizer recognizer = null;
        SQLStatement ast = (SQLStatement)asts.get(0);
        if ("mysql".equalsIgnoreCase(dbType)) {
            if (ast instanceof SQLInsertStatement) {
                recognizer = new MySQLInsertRecognizer(sql, ast);
            } else if (ast instanceof SQLUpdateStatement) {
                recognizer = new MySQLUpdateRecognizer(sql, ast);
            } else if (ast instanceof SQLDeleteStatement) {
                recognizer = new MySQLDeleteRecognizer(sql, ast);
            } else if (ast instanceof SQLSelectStatement && ((SQLSelectStatement)ast).getSelect().getFirstQueryBlock().isForUpdate()) {
                recognizer = new MySQLSelectForUpdateRecognizer(sql, ast);
            }
        } else {
            throw new UnsupportedOperationException("Just support MySQL by now!");
        }
        return recognizer;
    }
}

