/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.store.db;

import io.seata.common.exception.DataAccessException;
import io.seata.common.exception.StoreException;
import io.seata.common.executor.Initialize;
import io.seata.common.loader.LoadLevel;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.core.store.BranchTransactionDO;
import io.seata.core.store.GlobalTransactionDO;
import io.seata.core.store.LogStore;
import io.seata.core.store.db.LogStoreSqls;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="db")
public class LogStoreDataBaseDAO
implements LogStore,
Initialize {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogStoreDataBaseDAO.class);
    private static final String TRANSACTION_NAME_KEY = "TRANSACTION_NAME";
    private static final int TRANSACTION_NAME_DEFAULT_SIZE = 128;
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();
    protected DataSource logStoreDataSource = null;
    protected String globalTable;
    protected String brachTable;
    private String dbType;
    private int transactionNameColumnSize = 128;

    public LogStoreDataBaseDAO() {
    }

    public LogStoreDataBaseDAO(DataSource logStoreDataSource) {
        this.logStoreDataSource = logStoreDataSource;
    }

    @Override
    public void init() {
        this.globalTable = CONFIG.getConfig("store.db.global.table", "global_table");
        this.brachTable = CONFIG.getConfig("store.db.branch.table", "branch_table");
        this.dbType = CONFIG.getConfig("store.db.db-type");
        if (StringUtils.isBlank(this.dbType)) {
            throw new StoreException("there must be db type.");
        }
        if (this.logStoreDataSource == null) {
            throw new StoreException("there must be logStoreDataSource.");
        }
        this.initTransactionNameSize();
    }

    @Override
    public GlobalTransactionDO queryGlobalTransactionDO(String xid) {
        String sql = LogStoreSqls.getQueryGlobalTransactionSQL(this.globalTable, this.dbType);
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setString(1, xid);
            rs = ps.executeQuery();
            if (rs.next()) {
                GlobalTransactionDO globalTransactionDO = this.convertGlobalTransactionDO(rs);
                return globalTransactionDO;
            }
            GlobalTransactionDO globalTransactionDO = null;
            return globalTransactionDO;
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public GlobalTransactionDO queryGlobalTransactionDO(long transactionId) {
        String sql = LogStoreSqls.getQueryGlobalTransactionSQLByTransactionId(this.globalTable, this.dbType);
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setLong(1, transactionId);
            rs = ps.executeQuery();
            if (rs.next()) {
                GlobalTransactionDO globalTransactionDO = this.convertGlobalTransactionDO(rs);
                return globalTransactionDO;
            }
            GlobalTransactionDO globalTransactionDO = null;
            return globalTransactionDO;
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public List<GlobalTransactionDO> queryGlobalTransactionDO(int[] statuses, int limit) {
        ArrayList<GlobalTransactionDO> ret = new ArrayList<GlobalTransactionDO>();
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < statuses.length; ++i) {
                sb.append("?");
                if (i == statuses.length - 1) continue;
                sb.append(", ");
            }
            String sql = LogStoreSqls.getQueryGlobalTransactionSQLByStatus(this.globalTable, this.dbType, sb.toString());
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < statuses.length; ++i) {
                int status = statuses[i];
                ps.setInt(i + 1, status);
            }
            ps.setInt(statuses.length + 1, limit);
            rs = ps.executeQuery();
            while (rs.next()) {
                ret.add(this.convertGlobalTransactionDO(rs));
            }
            ArrayList<GlobalTransactionDO> arrayList = ret;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public boolean insertGlobalTransactionDO(GlobalTransactionDO globalTransactionDO) {
        String sql = LogStoreSqls.getInsertGlobalTransactionSQL(this.globalTable, this.dbType);
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setString(1, globalTransactionDO.getXid());
            ps.setLong(2, globalTransactionDO.getTransactionId());
            ps.setInt(3, globalTransactionDO.getStatus());
            ps.setString(4, globalTransactionDO.getApplicationId());
            ps.setString(5, globalTransactionDO.getTransactionServiceGroup());
            String transactionName = globalTransactionDO.getTransactionName();
            transactionName = transactionName.length() > this.transactionNameColumnSize ? transactionName.substring(0, this.transactionNameColumnSize) : transactionName;
            ps.setString(6, transactionName);
            ps.setInt(7, globalTransactionDO.getTimeout());
            ps.setLong(8, globalTransactionDO.getBeginTime());
            ps.setString(9, globalTransactionDO.getApplicationData());
            boolean bl = ps.executeUpdate() > 0;
            return bl;
        }
        catch (SQLException e) {
            throw new StoreException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public boolean updateGlobalTransactionDO(GlobalTransactionDO globalTransactionDO) {
        String sql = LogStoreSqls.getUpdateGlobalTransactionStatusSQL(this.globalTable, this.dbType);
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setInt(1, globalTransactionDO.getStatus());
            ps.setString(2, globalTransactionDO.getXid());
            boolean bl = ps.executeUpdate() > 0;
            return bl;
        }
        catch (SQLException e) {
            throw new StoreException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public boolean deleteGlobalTransactionDO(GlobalTransactionDO globalTransactionDO) {
        String sql = LogStoreSqls.getDeleteGlobalTransactionSQL(this.globalTable, this.dbType);
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setString(1, globalTransactionDO.getXid());
            boolean bl = ps.executeUpdate() > 0;
            return bl;
        }
        catch (SQLException e) {
            throw new StoreException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public List<BranchTransactionDO> queryBranchTransactionDO(String xid) {
        ArrayList<BranchTransactionDO> rets = new ArrayList<BranchTransactionDO>();
        String sql = LogStoreSqls.getQureyBranchTransaction(this.brachTable, this.dbType);
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setString(1, xid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                rets.add(this.convertBranchTransactionDO(rs));
            }
            ArrayList<BranchTransactionDO> arrayList = rets;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public boolean insertBranchTransactionDO(BranchTransactionDO branchTransactionDO) {
        String sql = LogStoreSqls.getInsertBranchTransactionSQL(this.brachTable, this.dbType);
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setString(1, branchTransactionDO.getXid());
            ps.setLong(2, branchTransactionDO.getTransactionId());
            ps.setLong(3, branchTransactionDO.getBranchId());
            ps.setString(4, branchTransactionDO.getResourceGroupId());
            ps.setString(5, branchTransactionDO.getResourceId());
            ps.setString(6, branchTransactionDO.getLockKey());
            ps.setString(7, branchTransactionDO.getBranchType());
            ps.setInt(8, branchTransactionDO.getStatus());
            ps.setString(9, branchTransactionDO.getClientId());
            ps.setString(10, branchTransactionDO.getApplicationData());
            boolean bl = ps.executeUpdate() > 0;
            return bl;
        }
        catch (SQLException e) {
            throw new StoreException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public boolean updateBranchTransactionDO(BranchTransactionDO branchTransactionDO) {
        String sql = LogStoreSqls.getUpdateBranchTransactionStatusSQL(this.brachTable, this.dbType);
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setInt(1, branchTransactionDO.getStatus());
            ps.setString(2, branchTransactionDO.getXid());
            ps.setLong(3, branchTransactionDO.getBranchId());
            boolean bl = ps.executeUpdate() > 0;
            return bl;
        }
        catch (SQLException e) {
            throw new StoreException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public boolean deleteBranchTransactionDO(BranchTransactionDO branchTransactionDO) {
        String sql = LogStoreSqls.getDeleteBranchTransactionByBranchIdSQL(this.brachTable, this.dbType);
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setString(1, branchTransactionDO.getXid());
            ps.setLong(2, branchTransactionDO.getBranchId());
            boolean bl = ps.executeUpdate() > 0;
            return bl;
        }
        catch (SQLException e) {
            throw new StoreException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private GlobalTransactionDO convertGlobalTransactionDO(ResultSet rs) throws SQLException {
        GlobalTransactionDO globalTransactionDO = new GlobalTransactionDO();
        globalTransactionDO.setXid(rs.getString("xid"));
        globalTransactionDO.setStatus(rs.getInt("status"));
        globalTransactionDO.setApplicationId(rs.getString("application_id"));
        globalTransactionDO.setBeginTime(rs.getLong("begin_time"));
        globalTransactionDO.setTimeout(rs.getInt("timeout"));
        globalTransactionDO.setTransactionId(rs.getLong("transaction_id"));
        globalTransactionDO.setTransactionName(rs.getString("transaction_name"));
        globalTransactionDO.setTransactionServiceGroup(rs.getString("transaction_service_group"));
        globalTransactionDO.setApplicationData(rs.getString("application_data"));
        globalTransactionDO.setGmtCreate(rs.getTimestamp("gmt_create"));
        globalTransactionDO.setGmtModified(rs.getTimestamp("gmt_modified"));
        return globalTransactionDO;
    }

    private BranchTransactionDO convertBranchTransactionDO(ResultSet rs) throws SQLException {
        BranchTransactionDO branchTransactionDO = new BranchTransactionDO();
        branchTransactionDO.setResourceGroupId(rs.getString("resource_group_id"));
        branchTransactionDO.setStatus(rs.getInt("status"));
        branchTransactionDO.setApplicationData(rs.getString("application_data"));
        branchTransactionDO.setClientId(rs.getString("client_id"));
        branchTransactionDO.setLockKey(rs.getString("lock_key"));
        branchTransactionDO.setXid(rs.getString("xid"));
        branchTransactionDO.setResourceId(rs.getString("resource_id"));
        branchTransactionDO.setBranchId(rs.getLong("branch_id"));
        branchTransactionDO.setBranchType(rs.getString("branch_type"));
        branchTransactionDO.setTransactionId(rs.getLong("transaction_id"));
        branchTransactionDO.setGmtCreate(rs.getTimestamp("gmt_create"));
        branchTransactionDO.setGmtModified(rs.getTimestamp("gmt_modified"));
        return branchTransactionDO;
    }

    public void initTransactionNameSize() {
        ColumnInfo columnInfo = this.queryTableStructure(this.globalTable, TRANSACTION_NAME_KEY);
        if (columnInfo == null) {
            LOGGER.warn("{} table or {} column not found", (Object)this.globalTable, (Object)TRANSACTION_NAME_KEY);
            return;
        }
        this.transactionNameColumnSize = columnInfo.getColumnSize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ColumnInfo queryTableStructure(String tableName, String colName) {
        try (Connection conn = this.logStoreDataSource.getConnection();){
            ColumnInfo info;
            String columnName;
            String table;
            DatabaseMetaData dbmd = conn.getMetaData();
            String schema = this.getSchema(conn);
            ResultSet tableRs = dbmd.getTables(null, schema, null, new String[]{"TABLE"});
            do {
                if (!tableRs.next()) return null;
            } while (!StringUtils.equalsIgnoreCase(table = tableRs.getString("TABLE_NAME"), tableName));
            ResultSet columnRs = conn.getMetaData().getColumns(null, schema, tableName, null);
            do {
                if (!columnRs.next()) return null;
                info = new ColumnInfo();
                columnName = columnRs.getString("COLUMN_NAME");
                info.setColumnName(columnName);
                String typeName = columnRs.getString("TYPE_NAME");
                info.setTypeName(typeName);
                int columnSize = columnRs.getInt("COLUMN_SIZE");
                info.setColumnSize(columnSize);
                String remarks = columnRs.getString("REMARKS");
                info.setRemarks(remarks);
            } while (!StringUtils.equalsIgnoreCase(columnName, colName));
            ColumnInfo columnInfo = info;
            return columnInfo;
        }
        catch (SQLException e) {
            LOGGER.error("query transaction_name size fail, {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    private String getSchema(Connection conn) throws SQLException {
        if ("h2".equalsIgnoreCase(this.dbType)) {
            return null;
        }
        return conn.getMetaData().getUserName();
    }

    public void setLogStoreDataSource(DataSource logStoreDataSource) {
        this.logStoreDataSource = logStoreDataSource;
    }

    public void setGlobalTable(String globalTable) {
        this.globalTable = globalTable;
    }

    public void setBrachTable(String brachTable) {
        this.brachTable = brachTable;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public int getTransactionNameColumnSize() {
        return this.transactionNameColumnSize;
    }

    private static class ColumnInfo {
        private String columnName;
        private String typeName;
        private int columnSize;
        private String remarks;

        private ColumnInfo() {
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public int getColumnSize() {
            return this.columnSize;
        }

        public void setColumnSize(int columnSize) {
            this.columnSize = columnSize;
        }

        public String getRemarks() {
            return this.remarks;
        }

        public void setRemarks(String remarks) {
            this.remarks = remarks;
        }
    }
}

