/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec;

import io.seata.rm.datasource.StatementProxy;
import io.seata.rm.datasource.exec.AbstractDMLBaseExecutor;
import io.seata.rm.datasource.exec.StatementCallback;
import io.seata.rm.datasource.sql.SQLRecognizer;
import io.seata.rm.datasource.sql.SQLUpdateRecognizer;
import io.seata.rm.datasource.sql.struct.Field;
import io.seata.rm.datasource.sql.struct.TableMeta;
import io.seata.rm.datasource.sql.struct.TableRecords;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.apache.commons.lang.StringUtils;

public class UpdateExecutor<T, S extends Statement>
extends AbstractDMLBaseExecutor<T, S> {
    public UpdateExecutor(StatementProxy statementProxy, StatementCallback statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    @Override
    protected TableRecords beforeImage() throws SQLException {
        ArrayList<List<Object>> paramAppenderList = new ArrayList<List<Object>>();
        TableMeta tmeta = this.getTableMeta();
        String selectSQL = this.buildBeforeImageSQL(tmeta, paramAppenderList);
        return this.buildTableRecords(tmeta, selectSQL, paramAppenderList);
    }

    private String buildBeforeImageSQL(TableMeta tableMeta, ArrayList<List<Object>> paramAppenderList) {
        SQLUpdateRecognizer recognizer = (SQLUpdateRecognizer)this.sqlRecognizer;
        List<String> updateColumns = recognizer.getUpdateColumns();
        StringBuilder prefix = new StringBuilder("SELECT ");
        if (!tableMeta.containsPK(updateColumns)) {
            prefix.append(this.getColumnNameInSQL(tableMeta.getPkName()) + ", ");
        }
        StringBuilder suffix = new StringBuilder(" FROM " + this.getFromTableInSQL());
        String whereCondition = this.buildWhereCondition(recognizer, paramAppenderList);
        if (StringUtils.isNotBlank((String)whereCondition)) {
            suffix.append(" WHERE " + whereCondition);
        }
        suffix.append(" FOR UPDATE");
        StringJoiner selectSQLJoin = new StringJoiner(", ", prefix.toString(), suffix.toString());
        for (String updateColumn : updateColumns) {
            selectSQLJoin.add(updateColumn);
        }
        return selectSQLJoin.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TableRecords afterImage(TableRecords beforeImage) throws SQLException {
        TableMeta tmeta = this.getTableMeta();
        if (beforeImage == null || beforeImage.size() == 0) {
            return TableRecords.empty(this.getTableMeta());
        }
        String selectSQL = this.buildAfterImageSQL(tmeta, beforeImage);
        TableRecords afterImage = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            pst = this.statementProxy.getConnection().prepareStatement(selectSQL);
            int index = 0;
            for (Field pkField : beforeImage.pkRows()) {
                pst.setObject(++index, pkField.getValue(), pkField.getType());
            }
            rs = pst.executeQuery();
            afterImage = TableRecords.buildRecords(tmeta, rs);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (pst != null) {
                pst.close();
            }
        }
        return afterImage;
    }

    private String buildAfterImageSQL(TableMeta tableMeta, TableRecords beforeImage) throws SQLException {
        SQLUpdateRecognizer recognizer = (SQLUpdateRecognizer)this.sqlRecognizer;
        List<String> updateColumns = recognizer.getUpdateColumns();
        StringBuilder prefix = new StringBuilder("SELECT ");
        if (!tableMeta.containsPK(updateColumns)) {
            prefix.append(this.getColumnNameInSQL(tableMeta.getPkName()) + ", ");
        }
        String suffix = " FROM " + this.getFromTableInSQL() + " WHERE " + this.buildWhereConditionByPKs(beforeImage.pkRows());
        StringJoiner selectSQLJoiner = new StringJoiner(", ", prefix.toString(), suffix);
        for (String column : updateColumns) {
            selectSQLJoiner.add(column);
        }
        return selectSQLJoiner.toString();
    }
}

