/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.rm;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.core.exception.TransactionException;
import io.seata.core.model.BranchStatus;
import io.seata.core.model.BranchType;
import io.seata.core.model.Resource;
import io.seata.rm.AbstractResourceManager;
import io.seata.saga.engine.exception.EngineExecutionException;
import io.seata.saga.engine.exception.ForwardInvalidException;
import io.seata.saga.rm.SagaResource;
import io.seata.saga.rm.StateMachineEngineHolder;
import io.seata.saga.statelang.domain.ExecutionStatus;
import io.seata.saga.statelang.domain.StateMachineInstance;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SagaResourceManager
extends AbstractResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SagaResourceManager.class);
    private Map<String, Resource> sagaResourceCache = new ConcurrentHashMap<String, Resource>();

    @Override
    public void registerResource(Resource resource) {
        SagaResource sagaResource = (SagaResource)resource;
        this.sagaResourceCache.put(sagaResource.getResourceId(), sagaResource);
        super.registerResource(sagaResource);
    }

    @Override
    public Map<String, Resource> getManagedResources() {
        return this.sagaResourceCache;
    }

    @Override
    public BranchStatus branchCommit(BranchType branchType, String xid, long branchId, String resourceId, String applicationData) throws TransactionException {
        block6: {
            try {
                StateMachineInstance machineInstance = StateMachineEngineHolder.getStateMachineEngine().forward(xid, null);
                if (ExecutionStatus.SU.equals((Object)machineInstance.getStatus()) && machineInstance.getCompensationStatus() == null) {
                    return BranchStatus.PhaseTwo_Committed;
                }
                if (ExecutionStatus.SU.equals((Object)machineInstance.getCompensationStatus())) {
                    return BranchStatus.PhaseTwo_Rollbacked;
                }
                if (ExecutionStatus.FA.equals((Object)machineInstance.getCompensationStatus()) || ExecutionStatus.UN.equals((Object)machineInstance.getCompensationStatus())) {
                    return BranchStatus.PhaseTwo_RollbackFailed_Retryable;
                }
                if (ExecutionStatus.FA.equals((Object)machineInstance.getStatus()) && machineInstance.getCompensationStatus() == null) {
                    return BranchStatus.PhaseOne_Failed;
                }
            }
            catch (ForwardInvalidException e) {
                LOGGER.error("StateMachine forward failed, xid: " + xid, (Throwable)e);
                if (!FrameworkErrorCode.StateMachineInstanceNotExists.equals((Object)e.getErrcode())) break block6;
                return BranchStatus.PhaseTwo_Committed;
            }
        }
        return BranchStatus.PhaseTwo_CommitFailed_Retryable;
    }

    @Override
    public BranchStatus branchRollback(BranchType branchType, String xid, long branchId, String resourceId, String applicationData) throws TransactionException {
        block3: {
            try {
                StateMachineInstance stateMachineInstance = StateMachineEngineHolder.getStateMachineEngine().compensate(xid, null);
                if (ExecutionStatus.SU.equals((Object)stateMachineInstance.getCompensationStatus())) {
                    return BranchStatus.PhaseTwo_Rollbacked;
                }
            }
            catch (EngineExecutionException e) {
                LOGGER.error("StateMachine compensate failed, xid: " + xid, (Throwable)e);
                if (!FrameworkErrorCode.StateMachineInstanceNotExists.equals((Object)e.getErrcode())) break block3;
                return BranchStatus.PhaseTwo_Rollbacked;
            }
        }
        return BranchStatus.PhaseTwo_RollbackFailed_Retryable;
    }

    @Override
    public BranchType getBranchType() {
        return BranchType.SAGA;
    }
}

