/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.statelang.parser.impl;

import io.seata.saga.statelang.domain.TaskState;
import io.seata.saga.statelang.domain.impl.AbstractTaskState;
import io.seata.saga.statelang.parser.impl.BaseStatePaser;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractTaskStateParser
extends BaseStatePaser {
    protected void parseTaskAttributes(AbstractTaskState state, Object node) {
        Map statusMap;
        Map outputMap;
        List inputList;
        List catchList;
        Map retryMap;
        this.parseBaseAttributes(state, node);
        Map nodeMap = (Map)node;
        state.setCompensateState((String)nodeMap.get("CompensateState"));
        state.setForCompensation("true".equals(nodeMap.get("IsForCompensation")));
        state.setForUpdate("true".equals(nodeMap.get("IsForUpdate")));
        if ("false".equals(nodeMap.get("IsPersist"))) {
            state.setPersist(false);
        }
        if ((retryMap = (Map)nodeMap.get("Retry")) != null) {
            state.setRetry(this.parseRetry(retryMap));
        }
        if ((catchList = (List)nodeMap.get("Catch")) != null) {
            state.setCatches(this.parseCatch(catchList));
        }
        if ((inputList = (List)nodeMap.get("Input")) != null) {
            state.setInput(inputList);
        }
        if ((outputMap = (Map)nodeMap.get("Output")) != null) {
            state.setOutput(outputMap);
        }
        if ((statusMap = (Map)nodeMap.get("Status")) != null) {
            state.setStatus(statusMap);
        }
    }

    protected TaskState.Retry parseRetry(Map<String, Object> retryMap) {
        AbstractTaskState.RetryImpl retry = new AbstractTaskState.RetryImpl();
        retry.setIntervalSeconds(((Double)retryMap.get("IntervalSeconds")).intValue());
        retry.setMaxAttempts(((Double)retryMap.get("MaxAttempts")).intValue());
        retry.setBackoffRate(new BigDecimal((Double)retryMap.get("BackoffRate")));
        return retry;
    }

    protected List<TaskState.ExceptionMatch> parseCatch(List<Object> catchList) {
        ArrayList<TaskState.ExceptionMatch> exceptionMatchList = new ArrayList<TaskState.ExceptionMatch>(catchList.size());
        for (Object exceptionMatchObj : catchList) {
            Map exceptionMatchMap = (Map)exceptionMatchObj;
            AbstractTaskState.ExceptionMatchImpl exceptionMatch = new AbstractTaskState.ExceptionMatchImpl();
            exceptionMatch.setExceptions((List)exceptionMatchMap.get("Exceptions"));
            exceptionMatch.setNext((String)exceptionMatchMap.get("Next"));
            exceptionMatchList.add(exceptionMatch);
        }
        return exceptionMatchList;
    }
}

