/*
 * Decompiled with CFR 0.152.
 */
package io.seata.integration.dubbo.alibaba;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import io.seata.core.context.RootContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"provider", "consumer"}, order=100)
public class TransactionPropagationFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionPropagationFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Result result;
        block14: {
            String xid = RootContext.getXID();
            String xidInterceptorType = RootContext.getXIDInterceptorType();
            String rpcXid = this.getRpcXid();
            String rpcXidInterceptorType = RpcContext.getContext().getAttachment("tx-xid-interceptor-type");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("xid in RootContext[{}] xid in RpcContext[{}]", (Object)xid, (Object)rpcXid);
            }
            boolean bind = false;
            if (xid != null) {
                RpcContext.getContext().setAttachment("TX_XID", xid);
                RpcContext.getContext().setAttachment("tx-xid-interceptor-type", xidInterceptorType);
            } else if (rpcXid != null) {
                RootContext.bind(rpcXid);
                RootContext.bindInterceptorType(rpcXidInterceptorType);
                bind = true;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("bind[{}] interceptorType[{}] to RootContext", (Object)rpcXid, (Object)rpcXidInterceptorType);
                }
            }
            try {
                result = invoker.invoke(invocation);
                if (!bind) break block14;
            }
            catch (Throwable throwable) {
                if (bind) {
                    String unbindInterceptorType = RootContext.unbindInterceptorType();
                    String unbindXid = RootContext.unbind();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("unbind[{}] interceptorType[{}] from RootContext", (Object)unbindXid, (Object)unbindInterceptorType);
                    }
                    if (!rpcXid.equalsIgnoreCase(unbindXid)) {
                        LOGGER.warn("xid in change during RPC from {} to {}, xidInterceptorType from {} to {} ", new Object[]{rpcXid, unbindXid, rpcXidInterceptorType, unbindInterceptorType});
                        if (unbindXid != null) {
                            RootContext.bind(unbindXid);
                            RootContext.bindInterceptorType(unbindInterceptorType);
                            LOGGER.warn("bind [{}] interceptorType[{}] back to RootContext", (Object)unbindXid, (Object)unbindInterceptorType);
                        }
                    }
                }
                throw throwable;
            }
            String unbindInterceptorType = RootContext.unbindInterceptorType();
            String unbindXid = RootContext.unbind();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("unbind[{}] interceptorType[{}] from RootContext", (Object)unbindXid, (Object)unbindInterceptorType);
            }
            if (!rpcXid.equalsIgnoreCase(unbindXid)) {
                LOGGER.warn("xid in change during RPC from {} to {}, xidInterceptorType from {} to {} ", new Object[]{rpcXid, unbindXid, rpcXidInterceptorType, unbindInterceptorType});
                if (unbindXid != null) {
                    RootContext.bind(unbindXid);
                    RootContext.bindInterceptorType(unbindInterceptorType);
                    LOGGER.warn("bind [{}] interceptorType[{}] back to RootContext", (Object)unbindXid, (Object)unbindInterceptorType);
                }
            }
        }
        return result;
    }

    private String getRpcXid() {
        String rpcXid = RpcContext.getContext().getAttachment("TX_XID");
        if (rpcXid == null) {
            rpcXid = RpcContext.getContext().getAttachment("TX_XID".toLowerCase());
        }
        return rpcXid;
    }
}

