/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.sql;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.rm.datasource.sql.SQLOperateRecognizerHolder;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLOperateRecognizerHolderFactory {
    private static volatile Map<String, SQLOperateRecognizerHolder> recognizerHolderMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static SQLOperateRecognizerHolder getSQLRecognizerHolder(String dbType) {
        if (recognizerHolderMap == null) {
            Class<SQLOperateRecognizerHolderFactory> clazz = SQLOperateRecognizerHolderFactory.class;
            // MONITORENTER : io.seata.rm.datasource.sql.SQLOperateRecognizerHolderFactory.class
            if (recognizerHolderMap == null) {
                HashMap<String, SQLOperateRecognizerHolder> initializedMap = new HashMap<String, SQLOperateRecognizerHolder>();
                List<SQLOperateRecognizerHolder> holderList = EnhancedServiceLoader.loadAll(SQLOperateRecognizerHolder.class);
                for (SQLOperateRecognizerHolder holder : holderList) {
                    initializedMap.put(holder.getDbType().toLowerCase(), holder);
                }
                recognizerHolderMap = initializedMap;
            }
            // MONITOREXIT : clazz
        }
        if (!recognizerHolderMap.containsKey(dbType)) throw new UnsupportedOperationException(MessageFormat.format("now not support {0}", dbType));
        return recognizerHolderMap.get(dbType);
    }
}

