/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.impl;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.saga.engine.AsyncCallback;
import io.seata.saga.engine.StateMachineConfig;
import io.seata.saga.engine.StateMachineEngine;
import io.seata.saga.engine.exception.EngineExecutionException;
import io.seata.saga.engine.exception.ForwardInvalidException;
import io.seata.saga.engine.pcext.StateInstruction;
import io.seata.saga.engine.pcext.interceptors.ServiceTaskHandlerInterceptor;
import io.seata.saga.engine.pcext.utils.EngineUtils;
import io.seata.saga.engine.utils.ProcessContextBuilder;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.proctrl.ProcessType;
import io.seata.saga.statelang.domain.ExecutionStatus;
import io.seata.saga.statelang.domain.State;
import io.seata.saga.statelang.domain.StateInstance;
import io.seata.saga.statelang.domain.StateMachine;
import io.seata.saga.statelang.domain.StateMachineInstance;
import io.seata.saga.statelang.domain.impl.AbstractTaskState;
import io.seata.saga.statelang.domain.impl.CompensationTriggerStateImpl;
import io.seata.saga.statelang.domain.impl.ServiceTaskStateImpl;
import io.seata.saga.statelang.domain.impl.StateMachineInstanceImpl;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ProcessCtrlStateMachineEngine
implements StateMachineEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessCtrlStateMachineEngine.class);
    private StateMachineConfig stateMachineConfig;

    private static void nullSafeCopy(Map<String, Object> srcMap, Map<String, Object> destMap) {
        for (String key : srcMap.keySet()) {
            Object value = srcMap.get(key);
            if (value == null) continue;
            destMap.put(key, value);
        }
    }

    @Override
    public StateMachineInstance start(String stateMachineName, String tenantId, Map<String, Object> startParams) throws EngineExecutionException {
        return this.startInternal(stateMachineName, tenantId, null, startParams, false, null);
    }

    @Override
    public StateMachineInstance startAsync(String stateMachineName, String tenantId, Map<String, Object> startParams, AsyncCallback callback) throws EngineExecutionException {
        return this.startInternal(stateMachineName, tenantId, null, startParams, true, callback);
    }

    @Override
    public StateMachineInstance startWithBusinessKey(String stateMachineName, String tenantId, String businessKey, Map<String, Object> startParams) throws EngineExecutionException {
        return this.startInternal(stateMachineName, tenantId, businessKey, startParams, false, null);
    }

    @Override
    public StateMachineInstance startWithBusinessKeyAsync(String stateMachineName, String tenantId, String businessKey, Map<String, Object> startParams, AsyncCallback callback) throws EngineExecutionException {
        return this.startInternal(stateMachineName, tenantId, businessKey, startParams, true, callback);
    }

    private StateMachineInstance startInternal(String stateMachineName, String tenantId, String businessKey, Map<String, Object> startParams, boolean async, AsyncCallback callback) throws EngineExecutionException {
        ConcurrentHashMap<String, Object> contextVariables;
        if (async && !this.stateMachineConfig.isEnableAsync()) {
            throw new EngineExecutionException("Asynchronous start is disabled. please set StateMachineConfig.enableAsync=true first.", FrameworkErrorCode.AsynchronousStartDisabled);
        }
        if (StringUtils.isEmpty((Object)tenantId)) {
            tenantId = this.stateMachineConfig.getDefaultTenantId();
        }
        StateMachineInstance instance = this.createMachineInstance(stateMachineName, tenantId, businessKey, startParams);
        ProcessContextBuilder contextBuilder = ProcessContextBuilder.create().withProcessType(ProcessType.STATE_LANG).withOperationName("start").withAsyncCallback(callback).withInstruction(new StateInstruction(stateMachineName, tenantId)).withStateMachineInstance(instance).withStateMachineConfig(this.getStateMachineConfig()).withStateMachineEngine(this);
        if (startParams != null) {
            contextVariables = new ConcurrentHashMap(startParams.size());
            ProcessCtrlStateMachineEngine.nullSafeCopy(startParams, contextVariables);
        } else {
            contextVariables = new ConcurrentHashMap<String, Object>();
        }
        instance.setContext(contextVariables);
        contextBuilder.withStateMachineContextVariables(contextVariables);
        ProcessContext processContext = contextBuilder.build();
        if (instance.getStateMachine().isPersist() && this.stateMachineConfig.getStateLogStore() != null) {
            this.stateMachineConfig.getStateLogStore().recordStateMachineStarted(instance, processContext);
        }
        if (StringUtils.isEmpty((Object)instance.getId())) {
            instance.setId(this.stateMachineConfig.getSeqGenerator().generate("STATE_MACHINE_INST"));
        }
        if (async) {
            this.stateMachineConfig.getAsyncProcessCtrlEventPublisher().publish(processContext);
        } else {
            this.stateMachineConfig.getProcessCtrlEventPublisher().publish(processContext);
        }
        return instance;
    }

    private StateMachineInstance createMachineInstance(String stateMachineName, String tenantId, String businessKey, Map<String, Object> startParams) {
        StateMachine stateMachine = this.stateMachineConfig.getStateMachineRepository().getStateMachine(stateMachineName, tenantId);
        if (stateMachine == null) {
            throw new EngineExecutionException("StateMachine[" + stateMachineName + "] is not exists", FrameworkErrorCode.ObjectNotExists);
        }
        StateMachineInstanceImpl inst = new StateMachineInstanceImpl();
        inst.setStateMachine(stateMachine);
        inst.setMachineId(stateMachine.getId());
        inst.setTenantId(tenantId);
        inst.setBusinessKey(businessKey);
        inst.setStartParams(startParams);
        if (StringUtils.hasText((String)businessKey) && startParams != null) {
            startParams.put("_business_key_", businessKey);
        }
        if (StringUtils.hasText((String)((String)startParams.get("_parent_id_")))) {
            inst.setParentId((String)startParams.get("_parent_id_"));
            startParams.remove("_parent_id_");
        }
        inst.setStatus(ExecutionStatus.RU);
        inst.setRunning(true);
        inst.setGmtStarted(new Date());
        inst.setGmtStarted(inst.getGmtStarted());
        return inst;
    }

    @Override
    public StateMachineInstance forward(String stateMachineInstId, Map<String, Object> replaceParams) throws EngineExecutionException {
        return this.forwardInternal(stateMachineInstId, replaceParams, false, false, null);
    }

    @Override
    public StateMachineInstance forwardAsync(String stateMachineInstId, Map<String, Object> replaceParams, AsyncCallback callback) throws EngineExecutionException {
        return this.forwardInternal(stateMachineInstId, replaceParams, false, true, callback);
    }

    protected StateMachineInstance forwardInternal(String stateMachineInstId, Map<String, Object> replaceParams, boolean skip, boolean async, AsyncCallback callback) throws EngineExecutionException {
        StateMachineInstance stateMachineInstance = this.reloadStateMachineInstance(stateMachineInstId);
        if (stateMachineInstance == null) {
            throw new ForwardInvalidException("StateMachineInstance is not exits", FrameworkErrorCode.StateMachineInstanceNotExists);
        }
        if (ExecutionStatus.SU.equals((Object)stateMachineInstance.getStatus()) && stateMachineInstance.getCompensationStatus() == null) {
            return stateMachineInstance;
        }
        ExecutionStatus[] acceptStatus = new ExecutionStatus[]{ExecutionStatus.FA, ExecutionStatus.UN};
        this.checkStatus(stateMachineInstance, acceptStatus, null, stateMachineInstance.getStatus(), null, "forward");
        List<StateInstance> actList = stateMachineInstance.getStateList();
        if (actList == null || actList.size() == 0) {
            throw new ForwardInvalidException("StateMachineInstance[id:" + stateMachineInstId + "] has no stateInstance, pls start a new StateMachine execution instead", FrameworkErrorCode.OperationDenied);
        }
        StateInstance lastForwardState = this.findOutLastForwardStateInstance(actList);
        if (lastForwardState == null) {
            throw new ForwardInvalidException("StateMachineInstance[id:" + stateMachineInstId + "] Cannot find last forward execution stateInstance", FrameworkErrorCode.OperationDenied);
        }
        ProcessContextBuilder contextBuilder = ProcessContextBuilder.create().withProcessType(ProcessType.STATE_LANG).withOperationName("forward").withAsyncCallback(callback).withStateMachineInstance(stateMachineInstance).withStateInstance(lastForwardState).withStateMachineConfig(this.getStateMachineConfig()).withStateMachineEngine(this);
        ProcessContext context = contextBuilder.build();
        Map<String, Object> contextVariables = this.getStateMachineContextVariables(context, stateMachineInstance);
        if (replaceParams != null) {
            contextVariables.putAll(replaceParams);
        }
        this.putBusinesskeyToContextariables(stateMachineInstance, contextVariables);
        ConcurrentHashMap<String, Object> concurrentContextVariables = new ConcurrentHashMap<String, Object>(contextVariables.size());
        ProcessCtrlStateMachineEngine.nullSafeCopy(contextVariables, concurrentContextVariables);
        context.setVariable("context", concurrentContextVariables);
        stateMachineInstance.setContext(concurrentContextVariables);
        context.setVariable(lastForwardState.getName() + "_retried_state_instance_id", lastForwardState.getId());
        if ("SubStateMachine".equals(lastForwardState.getType()) && !ExecutionStatus.SU.equals((Object)lastForwardState.getCompensationStatus())) {
            context.setVariable("_is_for_sub_statemachine_forward_", true);
        }
        if (!ExecutionStatus.SU.equals((Object)lastForwardState.getStatus())) {
            lastForwardState.setIgnoreStatus(true);
        }
        if (stateMachineInstance.getStateMachine().isPersist()) {
            this.stateMachineConfig.getStateLogStore().recordStateMachineRestarted(stateMachineInstance, context);
        }
        try {
            StateInstruction inst = new StateInstruction();
            inst.setTenantId(stateMachineInstance.getTenantId());
            inst.setStateMachineName(stateMachineInstance.getStateMachine().getName());
            if (skip || ExecutionStatus.SU.equals((Object)lastForwardState.getStatus())) {
                String next = null;
                State state = stateMachineInstance.getStateMachine().getState(lastForwardState.getName());
                if (state != null && state instanceof AbstractTaskState) {
                    next = ((AbstractTaskState)state).getNext();
                }
                if (StringUtils.isEmpty(next)) {
                    LOGGER.warn("Last Forward execution StateInstance was succeed, and it has not Next State , skip forward operation");
                    return stateMachineInstance;
                }
                inst.setStateName(next);
            } else {
                inst.setStateName(lastForwardState.getName());
            }
            context.setInstruction(inst);
            stateMachineInstance.setStatus(ExecutionStatus.RU);
            stateMachineInstance.setRunning(true);
            if (async) {
                this.stateMachineConfig.getAsyncProcessCtrlEventPublisher().publish(context);
            } else {
                this.stateMachineConfig.getProcessCtrlEventPublisher().publish(context);
            }
        }
        catch (EngineExecutionException e) {
            LOGGER.error("Operate [forward] failed", (Throwable)e);
            throw e;
        }
        return stateMachineInstance;
    }

    private Map<String, Object> getStateMachineContextVariables(ProcessContext context, StateMachineInstance stateMachineInstance) {
        Map<String, Object> contextVariables = stateMachineInstance.getEndParams();
        if (contextVariables == null || contextVariables.size() == 0) {
            contextVariables = stateMachineInstance.getStartParams();
        }
        if (contextVariables == null) {
            contextVariables = new HashMap<String, Object>();
        }
        if (stateMachineInstance.isRunning()) {
            List<StateInstance> stateInstanceList = stateMachineInstance.getStateList();
            if (stateInstanceList == null || stateInstanceList.size() == 0) {
                return contextVariables;
            }
            for (StateInstance stateInstance : stateInstanceList) {
                Object serviceOutputParams = stateInstance.getOutputParams();
                if (serviceOutputParams == null) continue;
                ServiceTaskStateImpl state = (ServiceTaskStateImpl)stateMachineInstance.getStateMachine().getState(stateInstance.getName());
                if (state == null) {
                    throw new EngineExecutionException("Cannot find State by state name [" + stateInstance.getName() + "], may be this is a bug", FrameworkErrorCode.ObjectNotExists);
                }
                if (state.getOutput() == null || state.getOutput().size() <= 0) continue;
                try {
                    Map<String, Object> outputVariablesToContext = ServiceTaskHandlerInterceptor.createOutputParams(this.stateMachineConfig.getExpressionFactoryManager(), state, serviceOutputParams);
                    if (outputVariablesToContext != null && outputVariablesToContext.size() > 0) {
                        contextVariables.putAll(outputVariablesToContext);
                    }
                    if (!StringUtils.hasLength((String)stateInstance.getBusinessKey())) continue;
                    ((Map)context.getVariable("context")).put(state.getName() + "_business_key_", stateInstance.getBusinessKey());
                }
                catch (Exception e) {
                    throw new EngineExecutionException(e, "Context variables replay faied", FrameworkErrorCode.ContextVariableReplayFailed);
                }
            }
        }
        return contextVariables;
    }

    public StateInstance findOutLastForwardStateInstance(List<StateInstance> stateInstanceList) {
        StateInstance lastForwardStateInstance = null;
        for (int i = stateInstanceList.size() - 1; i >= 0; --i) {
            StateInstance stateInstance = stateInstanceList.get(i);
            if (stateInstance.isForCompensation() || ExecutionStatus.SU.equals((Object)stateInstance.getCompensationStatus())) continue;
            if ("SubStateMachine".equals(stateInstance.getType())) {
                StateInstance finalState = stateInstance;
                while (StringUtils.hasText((String)finalState.getStateIdRetriedFor())) {
                    finalState = this.stateMachineConfig.getStateLogStore().getStateInstance(finalState.getStateIdRetriedFor(), finalState.getMachineInstanceId());
                }
                List<StateMachineInstance> subInst = this.stateMachineConfig.getStateLogStore().queryStateMachineInstanceByParentId(EngineUtils.generateParentId(finalState));
                if (subInst != null && subInst.size() > 0) {
                    if (ExecutionStatus.SU.equals((Object)subInst.get(0).getCompensationStatus())) continue;
                    if (ExecutionStatus.UN.equals((Object)subInst.get(0).getCompensationStatus())) {
                        throw new ForwardInvalidException("Last forward execution state instance is SubStateMachine and compensation status is [UN], Operation[forward] denied, stateInstanceId:" + stateInstance.getId(), FrameworkErrorCode.OperationDenied);
                    }
                }
            } else if (ExecutionStatus.UN.equals((Object)stateInstance.getCompensationStatus())) {
                throw new ForwardInvalidException("Last forward execution state instance compensation status is [UN], Operation[forward] denied, stateInstanceId:" + stateInstance.getId(), FrameworkErrorCode.OperationDenied);
            }
            lastForwardStateInstance = stateInstance;
            break;
        }
        return lastForwardStateInstance;
    }

    @Override
    public StateMachineInstance compensate(String stateMachineInstId, Map<String, Object> replaceParams) throws EngineExecutionException {
        return this.compensateInternal(stateMachineInstId, replaceParams, false, null);
    }

    @Override
    public StateMachineInstance compensateAsync(String stateMachineInstId, Map<String, Object> replaceParams, AsyncCallback callback) throws EngineExecutionException {
        return this.compensateInternal(stateMachineInstId, replaceParams, true, callback);
    }

    public StateMachineInstance compensateInternal(String stateMachineInstId, Map<String, Object> replaceParams, boolean async, AsyncCallback callback) throws EngineExecutionException {
        StateMachineInstance stateMachineInstance = this.reloadStateMachineInstance(stateMachineInstId);
        if (stateMachineInstance == null) {
            throw new EngineExecutionException("StateMachineInstance is not exits", FrameworkErrorCode.StateMachineInstanceNotExists);
        }
        if (ExecutionStatus.SU.equals((Object)stateMachineInstance.getCompensationStatus())) {
            return stateMachineInstance;
        }
        if (stateMachineInstance.getCompensationStatus() != null) {
            ExecutionStatus[] denyStatus = new ExecutionStatus[]{ExecutionStatus.SU};
            this.checkStatus(stateMachineInstance, null, denyStatus, null, stateMachineInstance.getCompensationStatus(), "compensate");
        }
        if (replaceParams != null) {
            stateMachineInstance.getEndParams().putAll(replaceParams);
        }
        ProcessContextBuilder contextBuilder = ProcessContextBuilder.create().withProcessType(ProcessType.STATE_LANG).withOperationName("compensate").withAsyncCallback(callback).withStateMachineInstance(stateMachineInstance).withStateMachineConfig(this.getStateMachineConfig()).withStateMachineEngine(this);
        ProcessContext context = contextBuilder.build();
        Map<String, Object> contextVariables = this.getStateMachineContextVariables(context, stateMachineInstance);
        if (replaceParams != null) {
            contextVariables.putAll(replaceParams);
        }
        this.putBusinesskeyToContextariables(stateMachineInstance, contextVariables);
        ConcurrentHashMap<String, Object> concurrentContextVariables = new ConcurrentHashMap<String, Object>(contextVariables.size());
        ProcessCtrlStateMachineEngine.nullSafeCopy(contextVariables, concurrentContextVariables);
        context.setVariable("context", concurrentContextVariables);
        stateMachineInstance.setContext(concurrentContextVariables);
        CompensationTriggerStateImpl tempCompensationTriggerState = new CompensationTriggerStateImpl();
        tempCompensationTriggerState.setStateMachine(stateMachineInstance.getStateMachine());
        stateMachineInstance.setRunning(true);
        if (stateMachineInstance.getStateMachine().isPersist()) {
            this.stateMachineConfig.getStateLogStore().recordStateMachineRestarted(stateMachineInstance, context);
        }
        try {
            StateInstruction inst = new StateInstruction();
            inst.setTenantId(stateMachineInstance.getTenantId());
            inst.setStateMachineName(stateMachineInstance.getStateMachine().getName());
            inst.setTemporaryState(tempCompensationTriggerState);
            context.setInstruction(inst);
            if (async) {
                this.stateMachineConfig.getAsyncProcessCtrlEventPublisher().publish(context);
            } else {
                this.stateMachineConfig.getProcessCtrlEventPublisher().publish(context);
            }
        }
        catch (EngineExecutionException e) {
            LOGGER.error("Operate [compensate] failed", (Throwable)e);
            throw e;
        }
        return stateMachineInstance;
    }

    @Override
    public StateMachineInstance skipAndForward(String stateMachineInstId) throws EngineExecutionException {
        return this.forwardInternal(stateMachineInstId, null, false, true, null);
    }

    @Override
    public StateMachineInstance skipAndForwardAsync(String stateMachineInstId, AsyncCallback callback) throws EngineExecutionException {
        return this.forwardInternal(stateMachineInstId, null, false, true, callback);
    }

    protected StateMachineInstance reloadStateMachineInstance(String instId) {
        StateMachineInstance inst = this.stateMachineConfig.getStateLogStore().getStateMachineInstance(instId);
        if (inst != null) {
            StateMachine stateMachine = inst.getStateMachine();
            if (stateMachine == null) {
                stateMachine = this.stateMachineConfig.getStateMachineRepository().getStateMachineById(inst.getMachineId());
                inst.setStateMachine(stateMachine);
            }
            if (stateMachine == null) {
                throw new EngineExecutionException("StateMachine[id:" + inst.getMachineId() + "] not exist.", FrameworkErrorCode.ObjectNotExists);
            }
            List<StateInstance> stateList = inst.getStateList();
            if ((stateList == null || stateList.size() == 0) && (stateList = this.stateMachineConfig.getStateLogStore().queryStateInstanceListByMachineInstanceId(instId)) != null && stateList.size() > 0) {
                for (StateInstance tmpStateInstance : stateList) {
                    inst.putStateInstance(tmpStateInstance.getId(), tmpStateInstance);
                }
            }
        }
        return inst;
    }

    protected boolean checkStatus(StateMachineInstance stateMachineInstance, ExecutionStatus[] acceptStatus, ExecutionStatus[] denyStatus, ExecutionStatus status, ExecutionStatus compenStatus, String operation) {
        ExecutionStatus currentStatus;
        if (status != null && compenStatus != null) {
            throw new EngineExecutionException("status and compensationStatus are not supported at the same time", FrameworkErrorCode.InvalidParameter);
        }
        if (status == null && compenStatus == null) {
            throw new EngineExecutionException("status and compensationStatus must input at least one", FrameworkErrorCode.InvalidParameter);
        }
        if (ExecutionStatus.SU.equals((Object)compenStatus)) {
            String message = this.buildExceptionMessage(stateMachineInstance, null, null, null, ExecutionStatus.SU, operation);
            throw new EngineExecutionException(message, FrameworkErrorCode.OperationDenied);
        }
        if (stateMachineInstance.isRunning()) {
            throw new EngineExecutionException("StateMachineInstance [id:" + stateMachineInstance.getId() + "]is running, operation[" + operation + "] denied", FrameworkErrorCode.OperationDenied);
        }
        if (!(denyStatus != null && denyStatus.length != 0 || acceptStatus != null && acceptStatus.length != 0)) {
            throw new EngineExecutionException("StateMachineInstance[id:" + stateMachineInstance.getId() + "], acceptable status and deny status must input at least one", FrameworkErrorCode.InvalidParameter);
        }
        ExecutionStatus executionStatus = currentStatus = status != null ? status : compenStatus;
        if (denyStatus != null && denyStatus.length != 0) {
            for (ExecutionStatus tempDenyStatus : denyStatus) {
                if (tempDenyStatus.compareTo(currentStatus) != 0) continue;
                String message = this.buildExceptionMessage(stateMachineInstance, acceptStatus, denyStatus, status, compenStatus, operation);
                throw new EngineExecutionException(message, FrameworkErrorCode.OperationDenied);
            }
        }
        if (acceptStatus == null || acceptStatus.length == 0) {
            return true;
        }
        for (ExecutionStatus tempStatus : acceptStatus) {
            if (tempStatus.compareTo(currentStatus) != 0) continue;
            return true;
        }
        String message = this.buildExceptionMessage(stateMachineInstance, acceptStatus, denyStatus, status, compenStatus, operation);
        throw new EngineExecutionException(message, FrameworkErrorCode.OperationDenied);
    }

    private String buildExceptionMessage(StateMachineInstance stateMachineInstance, ExecutionStatus[] acceptStatus, ExecutionStatus[] denyStatus, ExecutionStatus status, ExecutionStatus compenStatus, String operation) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("StateMachineInstance[id:").append(stateMachineInstance.getId()).append("]");
        if (acceptStatus != null) {
            stringBuilder.append(",acceptable status :");
            for (ExecutionStatus tempStatus : acceptStatus) {
                stringBuilder.append(tempStatus.toString());
                stringBuilder.append(" ");
            }
        }
        if (denyStatus != null) {
            stringBuilder.append(",deny status:");
            for (ExecutionStatus tempStatus : denyStatus) {
                stringBuilder.append(tempStatus.toString());
                stringBuilder.append(" ");
            }
        }
        if (status != null) {
            stringBuilder.append(",current status:");
            stringBuilder.append(status.toString());
        }
        if (compenStatus != null) {
            stringBuilder.append(",current compensation status:");
            stringBuilder.append(compenStatus.toString());
        }
        stringBuilder.append(",so operation [").append(operation).append("] denied");
        return stringBuilder.toString();
    }

    private void putBusinesskeyToContextariables(StateMachineInstance stateMachineInstance, Map<String, Object> contextVariables) {
        if (StringUtils.hasText((String)stateMachineInstance.getBusinessKey()) && !contextVariables.containsKey("_business_key_")) {
            contextVariables.put("_business_key_", stateMachineInstance.getBusinessKey());
        }
    }

    @Override
    public StateMachineConfig getStateMachineConfig() {
        return this.stateMachineConfig;
    }

    public void setStateMachineConfig(StateMachineConfig stateMachineConfig) {
        this.stateMachineConfig = stateMachineConfig;
    }
}

