/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.context;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.util.StringUtils;
import io.seata.core.context.ContextCore;
import io.seata.core.context.ContextCoreLoader;
import io.seata.core.model.BranchType;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(RootContext.class);
    public static final String KEY_XID = "TX_XID";
    public static final String KEY_BRANCH_TYPE = "TX_BRANCH_TYPE";
    public static final String KEY_GLOBAL_LOCK_FLAG = "TX_LOCK";
    private static ContextCore CONTEXT_HOLDER = ContextCoreLoader.load();

    private RootContext() {
    }

    public static String getXID() {
        String xid = CONTEXT_HOLDER.get(KEY_XID);
        if (StringUtils.isNotBlank(xid)) {
            return xid;
        }
        return null;
    }

    public static void bind(String xid) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("bind {}", (Object)xid);
        }
        CONTEXT_HOLDER.put(KEY_XID, xid);
    }

    public static void bindGlobalLockFlag() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Local Transaction Global Lock support enabled");
        }
        CONTEXT_HOLDER.put(KEY_GLOBAL_LOCK_FLAG, KEY_GLOBAL_LOCK_FLAG);
    }

    public static String unbind() {
        String xid = CONTEXT_HOLDER.remove(KEY_XID);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("unbind {} ", (Object)xid);
        }
        return xid;
    }

    public static void unbindGlobalLockFlag() {
        String lockFlag = CONTEXT_HOLDER.remove(KEY_GLOBAL_LOCK_FLAG);
        if (LOGGER.isDebugEnabled() && lockFlag != null) {
            LOGGER.debug("unbind global lock flag");
        }
    }

    public static boolean inGlobalTransaction() {
        return CONTEXT_HOLDER.get(KEY_XID) != null;
    }

    public static String getBranchType() {
        if (RootContext.inGlobalTransaction()) {
            String branchType = CONTEXT_HOLDER.get(KEY_BRANCH_TYPE);
            if (StringUtils.isNotBlank(branchType)) {
                return branchType;
            }
            return BranchType.AT.name();
        }
        return null;
    }

    public static void bindBranchType(BranchType branchType) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("bind branch type {}", (Object)branchType);
        }
        CONTEXT_HOLDER.put(KEY_BRANCH_TYPE, branchType.name());
    }

    public static String unbindBranchType() {
        String unbindBranchType = CONTEXT_HOLDER.remove(KEY_BRANCH_TYPE);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("unbind branch type {}", (Object)unbindBranchType);
        }
        return unbindBranchType;
    }

    public static boolean requireGlobalLock() {
        return CONTEXT_HOLDER.get(KEY_GLOBAL_LOCK_FLAG) != null;
    }

    public static void assertNotInGlobalTransaction() {
        if (RootContext.inGlobalTransaction()) {
            throw new ShouldNeverHappenException();
        }
    }

    public static Map<String, String> entries() {
        return CONTEXT_HOLDER.entries();
    }
}

