/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.serializer;

public enum SerializerType {
    SEATA(1),
    PROTOBUF(2),
    KRYO(4),
    FST(8);

    private final byte code;

    private SerializerType(byte code) {
        this.code = code;
    }

    public static SerializerType getByCode(int code) {
        for (SerializerType b : SerializerType.values()) {
            if (code != b.code) continue;
            return b;
        }
        throw new IllegalArgumentException("unknown codec:" + code);
    }

    public static SerializerType getByName(String name) {
        for (SerializerType b : SerializerType.values()) {
            if (!b.name().equalsIgnoreCase(name)) continue;
            return b;
        }
        throw new IllegalArgumentException("unknown codec:" + name);
    }

    public byte getCode() {
        return this.code;
    }
}

