/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.sql.struct.cache;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.loader.LoadLevel;
import io.seata.common.util.StringUtils;
import io.seata.rm.datasource.sql.struct.ColumnMeta;
import io.seata.rm.datasource.sql.struct.IndexMeta;
import io.seata.rm.datasource.sql.struct.IndexType;
import io.seata.rm.datasource.sql.struct.TableMeta;
import io.seata.rm.datasource.sql.struct.cache.AbstractTableMetaCache;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

@LoadLevel(name="postgresql")
public class PostgresqlTableMetaCache
extends AbstractTableMetaCache {
    @Override
    protected String getCacheKey(Connection connection, String tableName, String resourceId) {
        String defaultTableName;
        StringBuilder cacheKey = new StringBuilder(resourceId);
        cacheKey.append(".");
        String[] tableNameWithSchema = tableName.split("\\.");
        String string = defaultTableName = tableNameWithSchema.length > 1 ? tableNameWithSchema[1] : tableNameWithSchema[0];
        if (defaultTableName.contains("\"")) {
            cacheKey.append(defaultTableName.replace("\"", ""));
        } else {
            cacheKey.append(defaultTableName.toLowerCase());
        }
        return cacheKey.toString();
    }

    @Override
    protected TableMeta fetchSchema(Connection connection, String tableName) throws SQLException {
        try {
            DatabaseMetaData dbmd = connection.getMetaData();
            return this.resultSetMetaToSchema(dbmd, tableName);
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (Exception e) {
            throw new SQLException("Failed to fetch schema of " + tableName, e);
        }
    }

    private TableMeta resultSetMetaToSchema(DatabaseMetaData dbmd, String tableName) throws SQLException {
        TableMeta tm = new TableMeta();
        tm.setTableName(tableName);
        String[] schemaTable = tableName.split("\\.");
        String schemaName = schemaTable.length > 1 ? schemaTable[0] : null;
        String string = tableName = schemaTable.length > 1 ? schemaTable[1] : tableName;
        if (schemaName != null) {
            schemaName = schemaName.startsWith("\"") && schemaName.endsWith("\"") ? schemaName.replaceAll("(^\")|(\"$)", "") : schemaName.toLowerCase();
        }
        tableName = tableName.startsWith("\"") && tableName.endsWith("\"") ? tableName.replaceAll("(^\")|(\"$)", "") : tableName.toLowerCase();
        try (ResultSet rsColumns = dbmd.getColumns(null, schemaName, tableName, "%");
             ResultSet rsIndex = dbmd.getIndexInfo(null, schemaName, tableName, false, true);
             ResultSet rsPrimary = dbmd.getPrimaryKeys(null, schemaName, tableName);){
            while (rsColumns.next()) {
                ColumnMeta col = new ColumnMeta();
                col.setTableCat(rsColumns.getString("TABLE_CAT"));
                col.setTableSchemaName(rsColumns.getString("TABLE_SCHEM"));
                col.setTableName(rsColumns.getString("TABLE_NAME"));
                col.setColumnName(rsColumns.getString("COLUMN_NAME"));
                col.setDataType(rsColumns.getInt("DATA_TYPE"));
                col.setDataTypeName(rsColumns.getString("TYPE_NAME"));
                col.setColumnSize(rsColumns.getInt("COLUMN_SIZE"));
                col.setDecimalDigits(rsColumns.getInt("DECIMAL_DIGITS"));
                col.setNumPrecRadix(rsColumns.getInt("NUM_PREC_RADIX"));
                col.setNullAble(rsColumns.getInt("NULLABLE"));
                col.setRemarks(rsColumns.getString("REMARKS"));
                col.setColumnDef(rsColumns.getString("COLUMN_DEF"));
                col.setSqlDataType(rsColumns.getInt("SQL_DATA_TYPE"));
                col.setSqlDatetimeSub(rsColumns.getInt("SQL_DATETIME_SUB"));
                col.setCharOctetLength(rsColumns.getObject("CHAR_OCTET_LENGTH"));
                col.setOrdinalPosition(rsColumns.getInt("ORDINAL_POSITION"));
                col.setIsNullAble(rsColumns.getString("IS_NULLABLE"));
                col.setIsAutoincrement(rsColumns.getString("IS_AUTOINCREMENT"));
                tm.getAllColumns().put(col.getColumnName(), col);
            }
            while (rsIndex.next()) {
                IndexMeta index;
                String indexName = rsIndex.getString("INDEX_NAME");
                if (StringUtils.isNullOrEmpty(indexName)) continue;
                String colName = rsIndex.getString("COLUMN_NAME");
                ColumnMeta col = tm.getAllColumns().get(colName);
                if (tm.getAllIndexes().containsKey(indexName)) {
                    index = tm.getAllIndexes().get(indexName);
                    index.getValues().add(col);
                    continue;
                }
                index = new IndexMeta();
                index.setIndexName(indexName);
                index.setNonUnique(rsIndex.getBoolean("NON_UNIQUE"));
                index.setIndexQualifier(rsIndex.getString("INDEX_QUALIFIER"));
                index.setIndexName(rsIndex.getString("INDEX_NAME"));
                index.setType(rsIndex.getShort("TYPE"));
                index.setOrdinalPosition(rsIndex.getShort("ORDINAL_POSITION"));
                index.setAscOrDesc(rsIndex.getString("ASC_OR_DESC"));
                index.setCardinality(rsIndex.getInt("CARDINALITY"));
                index.getValues().add(col);
                if (!index.isNonUnique()) {
                    index.setIndextype(IndexType.UNIQUE);
                } else {
                    index.setIndextype(IndexType.NORMAL);
                }
                tm.getAllIndexes().put(indexName, index);
            }
            while (rsPrimary.next()) {
                String pkIndexName = rsPrimary.getString("PK_NAME");
                if (!tm.getAllIndexes().containsKey(pkIndexName)) continue;
                IndexMeta index = tm.getAllIndexes().get(pkIndexName);
                index.setIndextype(IndexType.PRIMARY);
            }
            if (tm.getAllIndexes().isEmpty()) {
                throw new ShouldNeverHappenException("Could not found any index in the table: " + tableName);
            }
        }
        return tm;
    }
}

