/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import io.seata.common.Constants;
import io.seata.common.executor.Initialize;
import io.seata.common.loader.LoadLevel;
import io.seata.rm.datasource.undo.BranchUndoLog;
import io.seata.rm.datasource.undo.UndoLogParser;

@LoadLevel(name="fastjson")
public class FastjsonUndoLogParser
implements UndoLogParser,
Initialize {
    public static final String NAME = "fastjson";
    private final SimplePropertyPreFilter filter = new SimplePropertyPreFilter(new String[0]);

    @Override
    public void init() {
        this.filter.getExcludes().add("tableMeta");
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte[] getDefaultContent() {
        return "{}".getBytes(Constants.DEFAULT_CHARSET);
    }

    @Override
    public byte[] encode(BranchUndoLog branchUndoLog) {
        String json = JSON.toJSONString((Object)branchUndoLog, (SerializeFilter)this.filter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
        return json.getBytes(Constants.DEFAULT_CHARSET);
    }

    @Override
    public BranchUndoLog decode(byte[] bytes) {
        String text = new String(bytes, Constants.DEFAULT_CHARSET);
        return (BranchUndoLog)JSON.parseObject((String)text, BranchUndoLog.class);
    }
}

