/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.xa;

import io.seata.core.context.RootContext;
import io.seata.core.model.BranchType;
import io.seata.rm.datasource.util.JdbcUtils;
import io.seata.rm.datasource.util.XAUtils;
import io.seata.rm.datasource.xa.AbstractDataSourceProxyXA;
import io.seata.rm.datasource.xa.ConnectionProxyXA;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;

public class DataSourceProxyXA
extends AbstractDataSourceProxyXA {
    public DataSourceProxyXA(DataSource dataSource) {
        this(dataSource, "DEFAULT_XA");
    }

    public DataSourceProxyXA(DataSource dataSource, String resourceGroupId) {
        this.dataSource = dataSource;
        this.branchType = BranchType.XA;
        JdbcUtils.initDataSourceResource(this, dataSource, resourceGroupId);
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        return this.getConnectionProxy(connection);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Connection connection = this.dataSource.getConnection(username, password);
        return this.getConnectionProxy(connection);
    }

    protected Connection getConnectionProxy(Connection connection) throws SQLException {
        Connection physicalConn = connection;
        if (connection instanceof PooledConnection) {
            physicalConn = ((PooledConnection)((Object)connection)).getConnection();
        }
        XAConnection xaConnection = XAUtils.createXAConnection(physicalConn, this);
        ConnectionProxyXA connectionProxyXA = new ConnectionProxyXA(connection, xaConnection, this, RootContext.getXID());
        connectionProxyXA.init();
        return connectionProxyXA;
    }
}

