/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc.netty.v1;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.core.compressor.Compressor;
import io.seata.core.compressor.CompressorFactory;
import io.seata.core.protocol.ProtocolConstants;
import io.seata.core.protocol.RpcMessage;
import io.seata.core.rpc.netty.v1.HeadMapSerializer;
import io.seata.core.serializer.Serializer;
import io.seata.core.serializer.SerializerType;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolV1Encoder
extends MessageToByteEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolV1Encoder.class);

    public void encode(ChannelHandlerContext ctx, Object msg, ByteBuf out) {
        try {
            int headLength;
            int fullLength;
            if (msg instanceof RpcMessage) {
                RpcMessage rpcMessage = (RpcMessage)msg;
                fullLength = 16;
                headLength = 16;
                byte messageType = rpcMessage.getMessageType();
                out.writeBytes(ProtocolConstants.MAGIC_CODE_BYTES);
                out.writeByte(1);
                out.writerIndex(out.writerIndex() + 6);
                out.writeByte((int)messageType);
                out.writeByte((int)rpcMessage.getCodec());
                out.writeByte((int)rpcMessage.getCompressor());
                out.writeInt(rpcMessage.getId());
                Map<String, String> headMap = rpcMessage.getHeadMap();
                if (headMap != null && !headMap.isEmpty()) {
                    int headMapBytesLength = HeadMapSerializer.getInstance().encode(headMap, out);
                    headLength += headMapBytesLength;
                    fullLength += headMapBytesLength;
                }
                byte[] bodyBytes = null;
                if (messageType != 3 && messageType != 4) {
                    Serializer serializer = EnhancedServiceLoader.load(Serializer.class, SerializerType.getByCode(rpcMessage.getCodec()).name());
                    bodyBytes = serializer.serialize(rpcMessage.getBody());
                    Compressor compressor = CompressorFactory.getCompressor(rpcMessage.getCompressor());
                    bodyBytes = compressor.compress(bodyBytes);
                    fullLength += bodyBytes.length;
                }
                if (bodyBytes != null) {
                    out.writeBytes(bodyBytes);
                }
            } else {
                throw new UnsupportedOperationException("Not support this class:" + msg.getClass());
            }
            int writeIndex = out.writerIndex();
            out.writerIndex(writeIndex - fullLength + 3);
            out.writeInt(fullLength);
            out.writeShort(headLength);
            out.writerIndex(writeIndex);
        }
        catch (Throwable e) {
            LOGGER.error("Encode request error!", e);
        }
    }
}

