/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.statelang.parser.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.seata.common.loader.LoadLevel;
import io.seata.saga.statelang.parser.JsonParser;

@LoadLevel(name="fastjson")
public class FastjsonParser
implements JsonParser {
    private static final SerializerFeature[] SERIALIZER_FEATURES = new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteClassName};
    private static final SerializerFeature[] SERIALIZER_FEATURES_PRETTY = new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteClassName, SerializerFeature.PrettyFormat};
    public static final String NAME = "fastjson";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String toJsonString(Object o, boolean prettyPrint) {
        if (prettyPrint) {
            return JSON.toJSONString((Object)o, (SerializerFeature[])SERIALIZER_FEATURES_PRETTY);
        }
        return JSON.toJSONString((Object)o, (SerializerFeature[])SERIALIZER_FEATURES);
    }

    @Override
    public <T> T parse(String json, Class<T> type, boolean ignoreAutoType) {
        if (ignoreAutoType) {
            return (T)JSON.parseObject((String)json, type, (Feature[])new Feature[]{Feature.IgnoreAutoType, Feature.OrderedField});
        }
        return (T)JSON.parseObject((String)json, type, (Feature[])new Feature[]{Feature.SupportAutoType, Feature.OrderedField});
    }
}

