/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.annotation.datasource;

import io.seata.common.util.CollectionUtils;
import io.seata.core.model.BranchType;
import io.seata.rm.datasource.DataSourceProxy;
import io.seata.rm.datasource.SeataDataSourceProxy;
import io.seata.rm.datasource.xa.DataSourceProxyXA;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class DataSourceProxyHolder {
    private static final int MAP_INITIAL_CAPACITY = 8;
    private ConcurrentHashMap<DataSource, SeataDataSourceProxy> dataSourceProxyMap = new ConcurrentHashMap(8);

    private DataSourceProxyHolder() {
    }

    public static DataSourceProxyHolder get() {
        return Holder.INSTANCE;
    }

    public SeataDataSourceProxy putDataSource(DataSource dataSource, BranchType dataSourceProxyMode) {
        DataSource originalDataSource;
        if (dataSource instanceof SeataDataSourceProxy) {
            SeataDataSourceProxy dataSourceProxy = (SeataDataSourceProxy)dataSource;
            if (dataSourceProxyMode == dataSourceProxy.getBranchType()) {
                return (SeataDataSourceProxy)dataSource;
            }
            originalDataSource = dataSourceProxy.getTargetDataSource();
        } else {
            originalDataSource = dataSource;
        }
        return CollectionUtils.computeIfAbsent(this.dataSourceProxyMap, originalDataSource, BranchType.XA == dataSourceProxyMode ? DataSourceProxyXA::new : DataSourceProxy::new);
    }

    private static class Holder {
        private static final DataSourceProxyHolder INSTANCE = new DataSourceProxyHolder();

        private Holder() {
        }
    }
}

