/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config;

import io.seata.common.util.DurationUtil;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationChangeEvent;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;

public class ConfigurationCache
implements ConfigurationChangeListener {
    private static final String METHOD_PREFIX = "get";
    private static final String METHOD_LATEST_CONFIG = "getLatestConfig";
    private static final ConcurrentHashMap<String, ObjectWrapper> CONFIG_CACHE = new ConcurrentHashMap();
    private Map<String, HashSet<ConfigurationChangeListener>> configListenersMap = new HashMap<String, HashSet<ConfigurationChangeListener>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConfigListener(String dataId, ConfigurationChangeListener ... listeners) {
        if (StringUtils.isBlank(dataId)) {
            return;
        }
        Class<ConfigurationCache> clazz = ConfigurationCache.class;
        synchronized (ConfigurationCache.class) {
            HashSet listenerHashSet = ConfigurationCache.getInstance().configListenersMap.computeIfAbsent(dataId, key -> new HashSet());
            if (!listenerHashSet.contains(ConfigurationCache.getInstance())) {
                ConfigurationFactory.getInstance().addConfigListener(dataId, ConfigurationCache.getInstance());
                listenerHashSet.add(ConfigurationCache.getInstance());
            }
            if (null != listeners && listeners.length > 0) {
                for (ConfigurationChangeListener listener : listeners) {
                    if (listenerHashSet.contains(listener)) continue;
                    listenerHashSet.add(listener);
                    ConfigurationFactory.getInstance().addConfigListener(dataId, listener);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static ConfigurationCache getInstance() {
        return ConfigurationCacheInstance.INSTANCE;
    }

    @Override
    public void onChangeEvent(ConfigurationChangeEvent event) {
        ObjectWrapper wrapper = CONFIG_CACHE.get(event.getDataId());
        if (StringUtils.isNotBlank(event.getNewValue())) {
            if (wrapper == null) {
                CONFIG_CACHE.put(event.getDataId(), new ObjectWrapper(event.getNewValue(), null));
            } else {
                Object newValue = new ObjectWrapper(event.getNewValue(), null).convertData(wrapper.getType());
                if (!Objects.equals(wrapper.getData(), newValue)) {
                    CONFIG_CACHE.put(event.getDataId(), new ObjectWrapper(newValue, wrapper.getType()));
                }
            }
        } else {
            CONFIG_CACHE.remove(event.getDataId());
        }
    }

    public Configuration proxy(Configuration originalConfiguration) {
        return (Configuration)Enhancer.create(Configuration.class, (Callback)((MethodInterceptor)(proxy, method, args, methodProxy) -> {
            if (method.getName().startsWith(METHOD_PREFIX) && !method.getName().equalsIgnoreCase(METHOD_LATEST_CONFIG)) {
                Object result;
                String rawDataId = (String)args[0];
                ObjectWrapper wrapper = CONFIG_CACHE.get(rawDataId);
                String type = method.getName().substring(METHOD_PREFIX.length());
                if (!ObjectWrapper.supportType(type)) {
                    type = null;
                }
                if (null == wrapper && (result = method.invoke((Object)originalConfiguration, args)) != null) {
                    wrapper = new ObjectWrapper(result, type);
                    CONFIG_CACHE.put(rawDataId, wrapper);
                }
                return wrapper == null ? null : wrapper.convertData(type);
            }
            return method.invoke((Object)originalConfiguration, args);
        }));
    }

    public void clear() {
        CONFIG_CACHE.clear();
    }

    private static class ObjectWrapper {
        static final String INT = "Int";
        static final String BOOLEAN = "Boolean";
        static final String DURATION = "Duration";
        static final String LONG = "Long";
        static final String SHORT = "Short";
        private final Object data;
        private final String type;

        ObjectWrapper(Object data, String type) {
            this.data = data;
            this.type = type;
        }

        public Object getData() {
            return this.data;
        }

        public String getType() {
            return this.type;
        }

        public Object convertData(String aType) {
            if (this.data != null && Objects.equals(this.type, aType)) {
                return this.data;
            }
            if (this.data != null) {
                if (INT.equals(aType)) {
                    return Integer.parseInt(this.data.toString());
                }
                if (BOOLEAN.equals(aType)) {
                    return Boolean.parseBoolean(this.data.toString());
                }
                if (DURATION.equals(aType)) {
                    return DurationUtil.parse(this.data.toString());
                }
                if (LONG.equals(aType)) {
                    return Long.parseLong(this.data.toString());
                }
                if (SHORT.equals(aType)) {
                    return Short.parseShort(this.data.toString());
                }
                return String.valueOf(this.data);
            }
            return null;
        }

        public static boolean supportType(String type) {
            return INT.equalsIgnoreCase(type) || BOOLEAN.equalsIgnoreCase(type) || DURATION.equalsIgnoreCase(type) || LONG.equalsIgnoreCase(type) || SHORT.equalsIgnoreCase(type);
        }
    }

    private static class ConfigurationCacheInstance {
        private static final ConfigurationCache INSTANCE = new ConfigurationCache();

        private ConfigurationCacheInstance() {
        }
    }
}

