/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc.processor.server;

import io.netty.channel.ChannelHandlerContext;
import io.seata.common.util.NetUtil;
import io.seata.core.protocol.AbstractResultMessage;
import io.seata.core.protocol.MessageFuture;
import io.seata.core.protocol.RpcMessage;
import io.seata.core.rpc.RpcContext;
import io.seata.core.rpc.TransactionMessageHandler;
import io.seata.core.rpc.netty.ChannelManager;
import io.seata.core.rpc.processor.RemotingProcessor;
import io.seata.core.rpc.processor.server.BatchLogHandler;
import io.seata.core.rpc.processor.server.ServerOnRequestProcessor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerOnResponseProcessor
implements RemotingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerOnRequestProcessor.class);
    private TransactionMessageHandler transactionMessageHandler;
    private ConcurrentMap<Integer, MessageFuture> futures;

    public ServerOnResponseProcessor(TransactionMessageHandler transactionMessageHandler, ConcurrentHashMap<Integer, MessageFuture> futures) {
        this.transactionMessageHandler = transactionMessageHandler;
        this.futures = futures;
    }

    @Override
    public void process(ChannelHandlerContext ctx, RpcMessage rpcMessage) throws Exception {
        MessageFuture messageFuture = (MessageFuture)this.futures.remove(rpcMessage.getId());
        if (messageFuture != null) {
            messageFuture.setResultMessage(rpcMessage.getBody());
        } else if (ChannelManager.isRegistered(ctx.channel())) {
            this.onResponseMessage(ctx, rpcMessage);
        } else {
            try {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("closeChannelHandlerContext channel:" + ctx.channel());
                }
                ctx.disconnect();
                ctx.close();
            }
            catch (Exception exx) {
                LOGGER.error(exx.getMessage());
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("close a unhandled connection! [%s]", ctx.channel().toString()));
            }
        }
    }

    private void onResponseMessage(ChannelHandlerContext ctx, RpcMessage rpcMessage) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("server received:{},clientIp:{},vgroup:{}", new Object[]{rpcMessage.getBody(), NetUtil.toIpAddress(ctx.channel().remoteAddress()), ChannelManager.getContextFromIdentified(ctx.channel()).getTransactionServiceGroup()});
        } else {
            try {
                BatchLogHandler.INSTANCE.getLogQueue().put(rpcMessage.getBody() + ",clientIp:" + NetUtil.toIpAddress(ctx.channel().remoteAddress()) + ",vgroup:" + ChannelManager.getContextFromIdentified(ctx.channel()).getTransactionServiceGroup());
            }
            catch (InterruptedException e) {
                LOGGER.error("put message to logQueue error: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (rpcMessage.getBody() instanceof AbstractResultMessage) {
            RpcContext rpcContext = ChannelManager.getContextFromIdentified(ctx.channel());
            this.transactionMessageHandler.onResponse((AbstractResultMessage)rpcMessage.getBody(), rpcContext);
        }
    }
}

