/*
 * Decompiled with CFR 0.152.
 */
package io.seata.integration.dubbo.alibaba;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import io.seata.common.util.StringUtils;
import io.seata.core.constants.DubboConstants;
import io.seata.core.context.RootContext;
import io.seata.core.model.BranchType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"provider", "consumer"}, order=100)
public class AlibabaDubboTransactionPropagationFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlibabaDubboTransactionPropagationFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Result result;
        block20: {
            if (!DubboConstants.ALIBABADUBBO) {
                return invoker.invoke(invocation);
            }
            String xid = RootContext.getXID();
            BranchType branchType = RootContext.getBranchType();
            String rpcXid = this.getRpcXid();
            String rpcBranchType = RpcContext.getContext().getAttachment("TX_BRANCH_TYPE");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("xid in RootContext[{}] xid in RpcContext[{}]", (Object)xid, (Object)rpcXid);
            }
            boolean bind = false;
            if (xid != null) {
                RpcContext.getContext().setAttachment("TX_XID", xid);
                RpcContext.getContext().setAttachment("TX_BRANCH_TYPE", branchType.name());
            } else if (rpcXid != null) {
                RootContext.bind(rpcXid);
                if (StringUtils.equals(BranchType.TCC.name(), rpcBranchType)) {
                    RootContext.bindBranchType(BranchType.TCC);
                }
                bind = true;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("bind xid [{}] branchType [{}] to RootContext", (Object)rpcXid, (Object)rpcBranchType);
                }
            }
            try {
                result = invoker.invoke(invocation);
                if (!bind) break block20;
            }
            catch (Throwable throwable) {
                if (bind) {
                    BranchType previousBranchType = RootContext.getBranchType();
                    String unbindXid = RootContext.unbind();
                    if (BranchType.TCC == previousBranchType) {
                        RootContext.unbindBranchType();
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("unbind xid [{}] branchType [{}] from RootContext", (Object)unbindXid, (Object)previousBranchType);
                    }
                    if (!rpcXid.equalsIgnoreCase(unbindXid)) {
                        LOGGER.warn("xid in change during RPC from {} to {},branchType from {} to {}", new Object[]{rpcXid, unbindXid, rpcBranchType != null ? rpcBranchType : "AT", previousBranchType});
                        if (unbindXid != null) {
                            RootContext.bind(unbindXid);
                            LOGGER.warn("bind xid [{}] back to RootContext", (Object)unbindXid);
                            if (BranchType.TCC == previousBranchType) {
                                RootContext.bindBranchType(BranchType.TCC);
                                LOGGER.warn("bind branchType [{}] back to RootContext", (Object)previousBranchType);
                            }
                        }
                    }
                }
                throw throwable;
            }
            BranchType previousBranchType = RootContext.getBranchType();
            String unbindXid = RootContext.unbind();
            if (BranchType.TCC == previousBranchType) {
                RootContext.unbindBranchType();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("unbind xid [{}] branchType [{}] from RootContext", (Object)unbindXid, (Object)previousBranchType);
            }
            if (!rpcXid.equalsIgnoreCase(unbindXid)) {
                LOGGER.warn("xid in change during RPC from {} to {},branchType from {} to {}", new Object[]{rpcXid, unbindXid, rpcBranchType != null ? rpcBranchType : "AT", previousBranchType});
                if (unbindXid != null) {
                    RootContext.bind(unbindXid);
                    LOGGER.warn("bind xid [{}] back to RootContext", (Object)unbindXid);
                    if (BranchType.TCC == previousBranchType) {
                        RootContext.bindBranchType(BranchType.TCC);
                        LOGGER.warn("bind branchType [{}] back to RootContext", (Object)previousBranchType);
                    }
                }
            }
        }
        return result;
    }

    private String getRpcXid() {
        String rpcXid = RpcContext.getContext().getAttachment("TX_XID");
        if (rpcXid == null) {
            rpcXid = RpcContext.getContext().getAttachment("TX_XID".toLowerCase());
        }
        return rpcXid;
    }
}

