/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec;

import io.seata.common.util.NumberUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationCache;
import io.seata.config.ConfigurationChangeEvent;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationFactory;
import io.seata.core.context.GlobalLockConfigHolder;
import io.seata.core.model.GlobalLockConfig;
import io.seata.rm.datasource.exec.LockWaitTimeoutException;

public class LockRetryController {
    private static final GlobalConfig LISTENER = new GlobalConfig();
    private int lockRetryInternal = this.getLockRetryInternal();
    private int lockRetryTimes = this.getLockRetryTimes();

    public void sleep(Exception e) throws LockWaitTimeoutException {
        if (--this.lockRetryTimes < 0) {
            throw new LockWaitTimeoutException("Global lock wait timeout", e);
        }
        try {
            Thread.sleep(this.lockRetryInternal);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    int getLockRetryInternal() {
        int configInternal;
        GlobalLockConfig config = GlobalLockConfigHolder.getCurrentGlobalLockConfig();
        if (config != null && (configInternal = config.getLockRetryInternal()) > 0) {
            return configInternal;
        }
        return LISTENER.getGlobalLockRetryInternal();
    }

    int getLockRetryTimes() {
        int configTimes;
        GlobalLockConfig config = GlobalLockConfigHolder.getCurrentGlobalLockConfig();
        if (config != null && (configTimes = config.getLockRetryTimes()) >= 0) {
            return configTimes;
        }
        return LISTENER.getGlobalLockRetryTimes();
    }

    static {
        ConfigurationCache.addConfigListener("client.rm.lock.retryInterval", LISTENER);
        ConfigurationCache.addConfigListener("client.rm.lock.retryTimes", LISTENER);
    }

    static class GlobalConfig
    implements ConfigurationChangeListener {
        private volatile int globalLockRetryInternal;
        private volatile int globalLockRetryTimes;
        private final int defaultRetryInternal = 10;
        private final int defaultRetryTimes = 30;

        public GlobalConfig() {
            Configuration configuration = ConfigurationFactory.getInstance();
            this.globalLockRetryInternal = configuration.getInt("client.rm.lock.retryInterval", 10);
            this.globalLockRetryTimes = configuration.getInt("client.rm.lock.retryTimes", 30);
        }

        @Override
        public void onChangeEvent(ConfigurationChangeEvent event) {
            String dataId = event.getDataId();
            String newValue = event.getNewValue();
            if ("client.rm.lock.retryInterval".equals(dataId)) {
                this.globalLockRetryInternal = NumberUtils.toInt(newValue, 10);
            }
            if ("client.rm.lock.retryTimes".equals(dataId)) {
                this.globalLockRetryTimes = NumberUtils.toInt(newValue, 30);
            }
        }

        public int getGlobalLockRetryInternal() {
            return this.globalLockRetryInternal;
        }

        public int getGlobalLockRetryTimes() {
            return this.globalLockRetryTimes;
        }
    }
}

