/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.pcext.interceptors;

import io.seata.common.loader.LoadLevel;
import io.seata.saga.engine.exception.EngineExecutionException;
import io.seata.saga.engine.pcext.InterceptableStateHandler;
import io.seata.saga.engine.pcext.StateHandlerInterceptor;
import io.seata.saga.engine.pcext.StateInstruction;
import io.seata.saga.engine.pcext.handlers.ServiceTaskStateHandler;
import io.seata.saga.engine.pcext.handlers.SubStateMachineHandler;
import io.seata.saga.engine.pcext.interceptors.ScriptTaskHandlerInterceptor;
import io.seata.saga.engine.pcext.utils.CompensationHolder;
import io.seata.saga.engine.pcext.utils.EngineUtils;
import io.seata.saga.engine.pcext.utils.LoopContextHolder;
import io.seata.saga.engine.pcext.utils.LoopTaskUtils;
import io.seata.saga.proctrl.HierarchicalProcessContext;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.statelang.domain.ExecutionStatus;
import io.seata.saga.statelang.domain.StateInstance;
import io.seata.saga.statelang.domain.TaskState;
import io.seata.saga.statelang.domain.impl.AbstractTaskState;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;

@LoadLevel(name="LoopTask", order=90)
public class LoopTaskHandlerInterceptor
implements StateHandlerInterceptor {
    @Override
    public boolean match(Class<? extends InterceptableStateHandler> clazz) {
        return clazz != null && (ServiceTaskStateHandler.class.isAssignableFrom(clazz) || SubStateMachineHandler.class.isAssignableFrom(clazz) || ScriptTaskHandlerInterceptor.class.isAssignableFrom(clazz));
    }

    @Override
    public void preProcess(ProcessContext context) throws EngineExecutionException {
        if (context.hasVariable("_is_loop_state_")) {
            int loopCounter;
            TaskState.Loop loop;
            StateInstruction instruction = context.getInstruction(StateInstruction.class);
            AbstractTaskState currentState = (AbstractTaskState)instruction.getState(context);
            if (context.hasVariable("_is_compensating_")) {
                CompensationHolder compensationHolder = CompensationHolder.getCurrent(context, true);
                StateInstance stateToBeCompensated = compensationHolder.getStatesNeedCompensation().get(currentState.getName());
                AbstractTaskState compensateState = (AbstractTaskState)stateToBeCompensated.getStateMachineInstance().getStateMachine().getState(EngineUtils.getOriginStateName(stateToBeCompensated));
                loop = compensateState.getLoop();
                loopCounter = LoopTaskUtils.reloadLoopCounter(stateToBeCompensated.getName());
            } else {
                loop = currentState.getLoop();
                loopCounter = (Integer)context.getVariable("loopCounter");
            }
            Collection collection = LoopContextHolder.getCurrent(context, true).getCollection();
            Map contextVariables = (Map)context.getVariable("context");
            ConcurrentHashMap<String, Object> copyContextVariables = new ConcurrentHashMap<String, Object>(contextVariables);
            copyContextVariables.put(loop.getElementIndexName(), loopCounter);
            copyContextVariables.put(loop.getElementVariableName(), this.iterator(collection, loopCounter));
            ((HierarchicalProcessContext)context).setVariableLocally("context", copyContextVariables);
        }
    }

    @Override
    public void postProcess(ProcessContext context, Exception e) throws EngineExecutionException {
        if (context.hasVariable("_is_loop_state_")) {
            Exception exp;
            StateInstance stateInstance = (StateInstance)context.getVariable("_current_state_instance_");
            if (null != stateInstance && !LoopContextHolder.getCurrent(context, true).isFailEnd() && !ExecutionStatus.SU.equals((Object)stateInstance.getStatus())) {
                LoopContextHolder.getCurrent(context, true).setFailEnd(true);
            }
            if ((exp = (Exception)((HierarchicalProcessContext)context).getVariableLocally("currentException")) == null) {
                exp = e;
            }
            if (null != e && context.hasVariable("loopSemaphore")) {
                Semaphore semaphore = (Semaphore)context.getVariable("loopSemaphore");
                semaphore.release();
            }
            if (null != exp) {
                LoopContextHolder.getCurrent(context, true).setFailEnd(true);
            } else {
                LoopContextHolder.getCurrent(context, true).getNrOfCompletedInstances().incrementAndGet();
            }
            LoopContextHolder.getCurrent(context, true).getNrOfActiveInstances().decrementAndGet();
        }
    }

    private Object iterator(Collection collection, int loopCounter) {
        Iterator iterator = collection.iterator();
        Object value = null;
        for (int index = 0; index <= loopCounter; ++index) {
            value = iterator.next();
        }
        return value;
    }
}

