/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.evaluation.expression;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.saga.engine.evaluation.Evaluator;
import io.seata.saga.engine.exception.EngineExecutionException;
import io.seata.saga.engine.expression.Expression;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ExpressionEvaluator
implements Evaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpressionEvaluator.class);
    private Expression expression;
    private String rootObjectName = "context";

    @Override
    public boolean evaluate(Map<String, Object> variables) {
        Object result;
        block4: {
            Object rootObject = StringUtils.hasText((String)this.rootObjectName) ? variables.get(this.rootObjectName) : variables;
            try {
                result = this.expression.getValue(rootObject);
            }
            catch (Exception e) {
                result = Boolean.FALSE;
                if (!LOGGER.isWarnEnabled()) break block4;
                LOGGER.warn("Expression [{}] execute failed, and it will return false by default. variables:{}", new Object[]{this.expression.getExpressionString(), variables, e});
            }
        }
        if (result == null) {
            throw new EngineExecutionException("Evaluation returns null", FrameworkErrorCode.EvaluationReturnsNull);
        }
        if (!(result instanceof Boolean)) {
            throw new EngineExecutionException("Evaluation returns non-Boolean: " + result + " (" + result.getClass().getName() + ")", FrameworkErrorCode.EvaluationReturnsNonBoolean);
        }
        return (Boolean)result;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public String getRootObjectName() {
        return this.rootObjectName;
    }

    public void setRootObjectName(String rootObjectName) {
        this.rootObjectName = rootObjectName;
    }
}

