/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.annotation;

import com.google.common.eventbus.Subscribe;
import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationCache;
import io.seata.config.ConfigurationChangeEvent;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationFactory;
import io.seata.core.event.EventBus;
import io.seata.core.event.GuavaEventBus;
import io.seata.core.model.GlobalLockConfig;
import io.seata.rm.GlobalLockExecutor;
import io.seata.rm.GlobalLockTemplate;
import io.seata.spring.annotation.AspectTransactional;
import io.seata.spring.annotation.GlobalLock;
import io.seata.spring.annotation.GlobalTransactional;
import io.seata.spring.annotation.SeataInterceptor;
import io.seata.spring.annotation.SeataInterceptorPosition;
import io.seata.spring.event.DegradeCheckEvent;
import io.seata.tm.TransactionManagerHolder;
import io.seata.tm.api.DefaultFailureHandlerImpl;
import io.seata.tm.api.FailureHandler;
import io.seata.tm.api.TransactionalExecutor;
import io.seata.tm.api.TransactionalTemplate;
import io.seata.tm.api.transaction.NoRollbackRule;
import io.seata.tm.api.transaction.RollbackRule;
import io.seata.tm.api.transaction.TransactionInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.util.ClassUtils;

public class GlobalTransactionalInterceptor
implements ConfigurationChangeListener,
MethodInterceptor,
SeataInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalTransactionalInterceptor.class);
    private static final FailureHandler DEFAULT_FAIL_HANDLER = new DefaultFailureHandlerImpl();
    private final TransactionalTemplate transactionalTemplate = new TransactionalTemplate();
    private final GlobalLockTemplate globalLockTemplate = new GlobalLockTemplate();
    private final FailureHandler failureHandler;
    private volatile boolean disable;
    private int order;
    protected AspectTransactional aspectTransactional;
    private static int degradeCheckPeriod;
    private static final AtomicBoolean ATOMIC_DEGRADE_CHECK;
    private static int degradeCheckAllowTimes;
    private static volatile Integer degradeNum;
    private static volatile Integer reachNum;
    private static final EventBus EVENT_BUS;
    private static volatile ScheduledThreadPoolExecutor executor;
    private static int defaultGlobalTransactionTimeout;

    private void initDefaultGlobalTransactionTimeout() {
        if (defaultGlobalTransactionTimeout <= 0) {
            int defaultGlobalTransactionTimeout;
            try {
                defaultGlobalTransactionTimeout = ConfigurationFactory.getInstance().getInt("client.tm.defaultGlobalTransactionTimeout", 60000);
            }
            catch (Exception e) {
                LOGGER.error("Illegal global transaction timeout value: " + e.getMessage());
                defaultGlobalTransactionTimeout = 60000;
            }
            if (defaultGlobalTransactionTimeout <= 0) {
                LOGGER.warn("Global transaction timeout value '{}' is illegal, and has been reset to the default value '{}'", (Object)defaultGlobalTransactionTimeout, (Object)60000);
                defaultGlobalTransactionTimeout = 60000;
            }
            GlobalTransactionalInterceptor.defaultGlobalTransactionTimeout = defaultGlobalTransactionTimeout;
        }
    }

    public GlobalTransactionalInterceptor() {
        this(null);
    }

    public GlobalTransactionalInterceptor(FailureHandler failureHandler) {
        this.failureHandler = failureHandler == null ? DEFAULT_FAIL_HANDLER : failureHandler;
        this.disable = ConfigurationFactory.getInstance().getBoolean("service.disableGlobalTransaction", false);
        this.order = ConfigurationFactory.getInstance().getInt("client.tm.interceptorOrder", -2147482648);
        boolean degradeCheck = ConfigurationFactory.getInstance().getBoolean("client.tm.degradeCheck", false);
        degradeCheckPeriod = ConfigurationFactory.getInstance().getInt("client.tm.degradeCheckPeriod", 2000);
        degradeCheckAllowTimes = ConfigurationFactory.getInstance().getInt("client.tm.degradeCheckAllowTimes", 10);
        EVENT_BUS.register(this);
        if (degradeCheck && degradeCheckPeriod > 0 && degradeCheckAllowTimes > 0) {
            GlobalTransactionalInterceptor.startDegradeCheck();
        }
        ConfigurationCache.addConfigListener("client.tm.degradeCheck", this);
        this.initDefaultGlobalTransactionTimeout();
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Class targetClass = methodInvocation.getThis() != null ? AopUtils.getTargetClass((Object)methodInvocation.getThis()) : null;
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)methodInvocation.getMethod(), (Class)targetClass);
        if (specificMethod != null && !specificMethod.getDeclaringClass().equals(Object.class)) {
            boolean localDisable;
            Method method = BridgeMethodResolver.findBridgedMethod((Method)specificMethod);
            GlobalTransactional globalTransactionalAnnotation = this.getAnnotation(method, targetClass, GlobalTransactional.class);
            GlobalLock globalLockAnnotation = this.getAnnotation(method, targetClass, GlobalLock.class);
            boolean bl = localDisable = this.disable || ATOMIC_DEGRADE_CHECK.get() && degradeNum >= degradeCheckAllowTimes;
            if (!localDisable) {
                if (globalTransactionalAnnotation != null || this.aspectTransactional != null) {
                    AspectTransactional transactional = globalTransactionalAnnotation != null ? new AspectTransactional(globalTransactionalAnnotation.timeoutMills(), globalTransactionalAnnotation.name(), globalTransactionalAnnotation.rollbackFor(), globalTransactionalAnnotation.rollbackForClassName(), globalTransactionalAnnotation.noRollbackFor(), globalTransactionalAnnotation.noRollbackForClassName(), globalTransactionalAnnotation.propagation(), globalTransactionalAnnotation.lockRetryInterval(), globalTransactionalAnnotation.lockRetryTimes(), globalTransactionalAnnotation.lockStrategyMode()) : this.aspectTransactional;
                    return this.handleGlobalTransaction(methodInvocation, transactional);
                }
                if (globalLockAnnotation != null) {
                    return this.handleGlobalLock(methodInvocation, globalLockAnnotation);
                }
            }
        }
        return methodInvocation.proceed();
    }

    private Object handleGlobalLock(final MethodInvocation methodInvocation, final GlobalLock globalLockAnno) throws Throwable {
        return this.globalLockTemplate.execute(new GlobalLockExecutor(){

            @Override
            public Object execute() throws Throwable {
                return methodInvocation.proceed();
            }

            @Override
            public GlobalLockConfig getGlobalLockConfig() {
                GlobalLockConfig config = new GlobalLockConfig();
                config.setLockRetryInterval(globalLockAnno.lockRetryInterval());
                config.setLockRetryTimes(globalLockAnno.lockRetryTimes());
                return config;
            }
        });
    }

    Object handleGlobalTransaction(final MethodInvocation methodInvocation, final AspectTransactional aspectTransactional) throws Throwable {
        boolean succeed = true;
        try {
            Object object = this.transactionalTemplate.execute(new TransactionalExecutor(){

                @Override
                public Object execute() throws Throwable {
                    return methodInvocation.proceed();
                }

                public String name() {
                    String name = aspectTransactional.getName();
                    if (!StringUtils.isNullOrEmpty(name)) {
                        return name;
                    }
                    return GlobalTransactionalInterceptor.this.formatMethod(methodInvocation.getMethod());
                }

                @Override
                public TransactionInfo getTransactionInfo() {
                    int timeout = aspectTransactional.getTimeoutMills();
                    if (timeout <= 0 || timeout == 60000) {
                        timeout = defaultGlobalTransactionTimeout;
                    }
                    TransactionInfo transactionInfo = new TransactionInfo();
                    transactionInfo.setTimeOut(timeout);
                    transactionInfo.setName(this.name());
                    transactionInfo.setPropagation(aspectTransactional.getPropagation());
                    transactionInfo.setLockRetryInterval(aspectTransactional.getLockRetryInterval());
                    transactionInfo.setLockRetryTimes(aspectTransactional.getLockRetryTimes());
                    transactionInfo.setLockStrategyMode(aspectTransactional.getLockStrategyMode());
                    LinkedHashSet<RollbackRule> rollbackRules = new LinkedHashSet<RollbackRule>();
                    for (Class<? extends Throwable> clazz : aspectTransactional.getRollbackFor()) {
                        rollbackRules.add(new RollbackRule(clazz));
                    }
                    for (String string : aspectTransactional.getRollbackForClassName()) {
                        rollbackRules.add(new RollbackRule(string));
                    }
                    for (Class<? extends Throwable> clazz : aspectTransactional.getNoRollbackFor()) {
                        rollbackRules.add(new NoRollbackRule(clazz));
                    }
                    for (String string : aspectTransactional.getNoRollbackForClassName()) {
                        rollbackRules.add(new NoRollbackRule(string));
                    }
                    transactionInfo.setRollbackRules(rollbackRules);
                    return transactionInfo;
                }
            });
            return object;
        }
        catch (TransactionalExecutor.ExecutionException e) {
            TransactionalExecutor.Code code = e.getCode();
            Throwable cause = e.getCause();
            switch (code) {
                case RollbackDone: {
                    throw e.getOriginalException();
                }
                case BeginFailure: {
                    succeed = false;
                    this.failureHandler.onBeginFailure(e.getTransaction(), cause);
                    throw cause;
                }
                case CommitFailure: {
                    succeed = false;
                    this.failureHandler.onCommitFailure(e.getTransaction(), cause);
                    throw cause;
                }
                case RollbackFailure: {
                    this.failureHandler.onRollbackFailure(e.getTransaction(), e.getOriginalException());
                    throw e.getOriginalException();
                }
                case RollbackRetrying: {
                    this.failureHandler.onRollbackRetrying(e.getTransaction(), e.getOriginalException());
                    throw e.getOriginalException();
                }
                case TimeoutRollback: {
                    this.failureHandler.onTimeoutRollback(e.getTransaction(), e.getOriginalException());
                    throw cause;
                }
            }
            throw new ShouldNeverHappenException(String.format("Unknown TransactionalExecutor.Code: %s", new Object[]{code}));
        }
        finally {
            if (ATOMIC_DEGRADE_CHECK.get()) {
                EVENT_BUS.post(new DegradeCheckEvent(succeed));
            }
        }
    }

    public <T extends Annotation> T getAnnotation(Method method, Class<?> targetClass, Class<T> annotationClass) {
        return (T)((Annotation)Optional.ofNullable(method).map(m -> m.getAnnotation(annotationClass)).orElse(Optional.ofNullable(targetClass).map(t -> t.getAnnotation(annotationClass)).orElse(null)));
    }

    private String formatMethod(Method method) {
        StringBuilder sb = new StringBuilder(method.getName()).append("(");
        Class<?>[] params = method.getParameterTypes();
        int in = 0;
        for (Class<?> clazz : params) {
            sb.append(clazz.getName());
            if (++in >= params.length) continue;
            sb.append(", ");
        }
        return sb.append(")").toString();
    }

    @Override
    public void onChangeEvent(ConfigurationChangeEvent event) {
        if ("service.disableGlobalTransaction".equals(event.getDataId())) {
            LOGGER.info("{} config changed, old value:{}, new value:{}", new Object[]{"service.disableGlobalTransaction", this.disable, event.getNewValue()});
            this.disable = Boolean.parseBoolean(event.getNewValue().trim());
        } else if ("client.tm.degradeCheck".equals(event.getDataId())) {
            boolean degradeCheck = Boolean.parseBoolean(event.getNewValue());
            if (!degradeCheck) {
                degradeNum = 0;
                GlobalTransactionalInterceptor.stopDegradeCheck();
            } else if (degradeCheckPeriod > 0 && degradeCheckAllowTimes > 0) {
                GlobalTransactionalInterceptor.startDegradeCheck();
            }
        }
    }

    private static void stopDegradeCheck() {
        if (!ATOMIC_DEGRADE_CHECK.compareAndSet(true, false)) {
            return;
        }
        if (executor != null && !executor.isShutdown()) {
            executor.shutdown();
        }
    }

    private static void startDegradeCheck() {
        if (!ATOMIC_DEGRADE_CHECK.compareAndSet(false, true)) {
            return;
        }
        if (executor != null && !executor.isShutdown()) {
            return;
        }
        executor = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("degradeCheckWorker", 1, true));
        executor.scheduleAtFixedRate(() -> {
            if (ATOMIC_DEGRADE_CHECK.get()) {
                try {
                    String xid = TransactionManagerHolder.get().begin(null, null, "degradeCheck", 60000);
                    TransactionManagerHolder.get().commit(xid);
                    EVENT_BUS.post(new DegradeCheckEvent(true));
                }
                catch (Exception e) {
                    EVENT_BUS.post(new DegradeCheckEvent(false));
                }
            }
        }, degradeCheckPeriod, degradeCheckPeriod, TimeUnit.MILLISECONDS);
    }

    @Subscribe
    public static void onDegradeCheck(DegradeCheckEvent event) {
        if (event.isRequestSuccess()) {
            if (degradeNum >= degradeCheckAllowTimes) {
                Integer n = reachNum;
                Integer n2 = reachNum = Integer.valueOf(reachNum + 1);
                if (reachNum >= degradeCheckAllowTimes) {
                    reachNum = 0;
                    degradeNum = 0;
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("the current global transaction has been restored");
                    }
                }
            } else if (degradeNum != 0) {
                degradeNum = 0;
            }
        } else if (degradeNum < degradeCheckAllowTimes) {
            Integer n = degradeNum;
            Integer n3 = degradeNum = Integer.valueOf(degradeNum + 1);
            if (degradeNum >= degradeCheckAllowTimes && LOGGER.isWarnEnabled()) {
                LOGGER.warn("the current global transaction has been automatically downgraded");
            }
        } else if (reachNum != 0) {
            reachNum = 0;
        }
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public SeataInterceptorPosition getPosition() {
        return SeataInterceptorPosition.BeforeTransaction;
    }

    static {
        ATOMIC_DEGRADE_CHECK = new AtomicBoolean(false);
        degradeNum = 0;
        reachNum = 0;
        EVENT_BUS = new GuavaEventBus("degradeCheckEventBus", true);
        defaultGlobalTransactionTimeout = 0;
    }
}

