/*
 * Decompiled with CFR 0.152.
 */
package io.seata.common.exception;

public enum FrameworkErrorCode {
    ThreadPoolFull("0004", "Thread pool is full", "Please check the thread pool configuration"),
    InitSeataClientError("0008", "Seata app name or seata server group is null", "Please check your configuration"),
    NullRuleError("0010", "Services rules is null", "Please check your configuration"),
    NetConnect("0101", "Can not connect to the server", "Please check if the seata service is started. Is the network connection to the seata server normal?"),
    NetRegAppname("0102", "Register client app name failed", "Please check if the seata service is started. Is the network connection to the seata server normal?"),
    NetDisconnect("0103", "Seata connection closed", "The network is disconnected. Please check the network connection to the client or seata server."),
    NetDispatch("0104", "Dispatch error", "Network processing error. Please check the network connection to the client or seata server."),
    NetOnMessage("0105", "On message error", "Network processing error. Please check the network connection to the client or seata server."),
    getChannelError("0106", "Get channel error", "Get channel error"),
    ChannelNotWritable("0107", "Channel not writable", "Channel not writable"),
    SendHalfMessageFailed("0108", "Send half message failed", "Send half message failed"),
    ChannelIsNotWritable("0109", "Channel is not writable", "Channel is not writable"),
    NoAvailableService("0110", "No available service", "No available service"),
    InvalidConfiguration("0201", "Invalid configuration", "Invalid configuration"),
    ExceptionCaught("0318", "Exception caught", "Exception caught"),
    RegisterRM("0304", "Register RM failed", "Register RM failed"),
    ProcessTypeNotFound("0401", "Process type not found", "Process type not found"),
    ProcessHandlerNotFound("0402", "Process handler not found", "Process handler not found"),
    ProcessRouterNotFound("0403", "Process router not found", "Process router not found"),
    MethodNotPublic("0404", "method not public", "method not public"),
    MethodInvokeError("0405", "method invoke error", "method invoke error"),
    CompensationStateNotFound("0406", "CompensationState not found", "CompensationState not found"),
    EvaluationReturnsNull("0407", "Evaluation returns null", "Evaluation returns null"),
    EvaluationReturnsNonBoolean("0408", "Evaluation returns non-Boolean", "Evaluation returns non-Boolean"),
    NotExceptionClass("0409", "Not a exception class", "Not a exception class"),
    NoSuchMethod("0410", "No such method", "No such method"),
    ObjectNotExists("0411", "Object not exists", "Object not exists"),
    ParameterRequired("0412", "Parameter required", "Parameter required"),
    VariablesAssignError("0413", "Variables assign error", "Variables assign error"),
    NoMatchedStatus("0414", "No matched status", "No matched status"),
    AsynchronousStartDisabled("0415", "Asynchronous start disabled", "Asynchronous start disabled"),
    OperationDenied("0416", "Operation denied", "Operation denied"),
    ContextVariableReplayFailed("0417", "Context variable replay failed", "Context variable replay failed"),
    InvalidParameter("0418", "Invalid parameter", "Invalid parameter"),
    TransactionManagerError("0419", "Invoke transaction manager error", "Invoke transaction manager error"),
    StateMachineInstanceNotExists("0420", "State machine instance not exists", "State machine instance not exists"),
    StateMachineExecutionTimeout("0421", "State machine execution timeout", "State machine execution timeout"),
    StateMachineNoChoiceMatched("0422", "State machine no choice matched", "State machine no choice matched"),
    DateSourceNeedInjected("0501", "TCC fence datasource need injected", "TCC fence datasource need injected"),
    RecordNotExists("0502", "TCC fence record not exists", "TCC fence record not exists"),
    InsertRecordError("0503", "Insert tcc fence record error", "Insert tcc fence record error"),
    DuplicateKeyException("0504", "Insert tcc fence record duplicate key exception", "Insert tcc fence record duplicate key exception"),
    TransactionManagerNeedInjected("0505", "TCC fence transactionManager need injected", "TCC fence transactionManager need injected"),
    UnknownAppError("10000", "Unknown error", "Internal error");

    private String errCode;
    private String errMessage;
    private String errDispose;

    private FrameworkErrorCode(String errCode, String errMessage, String errDispose) {
        this.errCode = errCode;
        this.errMessage = errMessage;
        this.errDispose = errDispose;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public String getErrMessage() {
        return this.errMessage;
    }

    public String getErrDispose() {
        return this.errDispose;
    }

    public String toString() {
        return String.format("[%s] [%s] [%s]", this.errCode, this.errMessage, this.errDispose);
    }
}

