/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.proctrl.eventing.impl;

import io.seata.common.exception.FrameworkException;
import io.seata.common.util.CollectionUtils;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.proctrl.eventing.EventConsumer;
import io.seata.saga.proctrl.eventing.impl.AbstractEventBus;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncEventBus
extends AbstractEventBus<ProcessContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncEventBus.class);
    private ThreadPoolExecutor threadPoolExecutor;

    @Override
    public boolean offer(ProcessContext context) throws FrameworkException {
        List<EventConsumer> eventConsumers = this.getEventConsumers((Class)context.getClass());
        if (CollectionUtils.isEmpty(eventConsumers)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("cannot find event handler by class: " + context.getClass());
            }
            return false;
        }
        for (EventConsumer eventConsumer : eventConsumers) {
            this.threadPoolExecutor.execute(() -> eventConsumer.process(context));
        }
        return true;
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }
}

