/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.aot;

import io.seata.spring.aot.AotUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;

class SeataServicesRuntimeHints
implements RuntimeHintsRegistrar {
    private static final Set<String> OTHER_SERVICES = new HashSet<String>();

    SeataServicesRuntimeHints() {
    }

    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        Predicate<Resource> predicate = this::isSeataServicesResource;
        AotUtils.registerServices(hints.reflection(), "classpath*:META-INF/services/*", predicate, AotUtils.MEMBER_CATEGORIES_FOR_INSTANTIATE);
        AotUtils.registerServices(hints.reflection(), "classpath*:META-INF/seata/*", predicate, AotUtils.MEMBER_CATEGORIES_FOR_INSTANTIATE);
    }

    private boolean isSeataServicesResource(Resource resource) {
        if (resource.getFilename() == null) {
            return false;
        }
        if (resource.getFilename().startsWith("io.seata.")) {
            return true;
        }
        return OTHER_SERVICES.contains(resource.getFilename());
    }

    static {
        OTHER_SERVICES.add("com.alibaba.dubbo.rpc.Filter");
        OTHER_SERVICES.add("com.alipay.sofa.rpc.filter.Filter");
        OTHER_SERVICES.add("com.taobao.hsf.invocation.filter.RPCFilter");
        OTHER_SERVICES.add("com.weibo.api.motan.filter.Filter");
    }
}

