/*
 * Decompiled with CFR 0.152.
 */
package io.seata.integration.grpc.interceptor.server;

import io.grpc.ServerCall;
import io.seata.common.util.StringUtils;
import io.seata.core.context.RootContext;
import java.util.Objects;

public class ServerListenerProxy<ReqT>
extends ServerCall.Listener<ReqT> {
    private ServerCall.Listener<ReqT> target;
    private String xid;

    public ServerListenerProxy(String xid, ServerCall.Listener<ReqT> target) {
        Objects.requireNonNull(target);
        this.target = target;
        this.xid = xid;
    }

    public void onMessage(ReqT message) {
        this.target.onMessage(message);
    }

    public void onHalfClose() {
        RootContext.unbind();
        if (StringUtils.isNotBlank(this.xid)) {
            RootContext.bind(this.xid);
        }
        this.target.onHalfClose();
    }

    public void onCancel() {
        this.target.onCancel();
    }

    public void onComplete() {
        this.target.onComplete();
    }

    public void onReady() {
        this.target.onReady();
    }
}

