/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource;

import io.seata.core.context.RootContext;
import io.seata.core.model.BranchType;
import io.seata.core.model.Resource;
import io.seata.rm.DefaultResourceManager;
import io.seata.rm.datasource.AbstractDataSourceProxy;
import io.seata.rm.datasource.ConnectionProxy;
import io.seata.rm.datasource.SeataDataSourceProxy;
import io.seata.rm.datasource.sql.struct.TableMetaCacheFactory;
import io.seata.rm.datasource.util.JdbcUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceProxy
extends AbstractDataSourceProxy
implements Resource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourceProxy.class);
    private static final String DEFAULT_RESOURCE_GROUP_ID = "DEFAULT";
    private String resourceGroupId;
    private String jdbcUrl;
    private String resourceId;
    private String dbType;
    private String userName;
    private String version;

    public DataSourceProxy(DataSource targetDataSource) {
        this(targetDataSource, DEFAULT_RESOURCE_GROUP_ID);
    }

    public DataSourceProxy(DataSource targetDataSource, String resourceGroupId) {
        if (targetDataSource instanceof SeataDataSourceProxy) {
            LOGGER.info("Unwrap the target data source, because the type is: {}", (Object)targetDataSource.getClass().getName());
            targetDataSource = ((SeataDataSourceProxy)targetDataSource).getTargetDataSource();
        }
        this.targetDataSource = targetDataSource;
        this.init(targetDataSource, resourceGroupId);
    }

    private void init(DataSource dataSource, String resourceGroupId) {
        this.resourceGroupId = resourceGroupId;
        try (Connection connection = dataSource.getConnection();){
            this.jdbcUrl = connection.getMetaData().getURL();
            this.dbType = JdbcUtils.getDbType(this.jdbcUrl);
            if ("oracle".equals(this.dbType)) {
                this.userName = connection.getMetaData().getUserName();
            } else if ("mysql".equals(this.dbType)) {
                this.getMySQLAdaptiveType(connection);
            }
            this.version = this.selectDbVersion(connection);
        }
        catch (SQLException e) {
            throw new IllegalStateException("can not init dataSource", e);
        }
        this.initResourceId();
        DefaultResourceManager.get().registerResource(this);
        TableMetaCacheFactory.registerTableMeta(this);
        RootContext.setDefaultBranchType(this.getBranchType());
    }

    private void getMySQLAdaptiveType(Connection connection) {
        try (Statement statement = connection.createStatement();){
            statement.executeQuery("show rule");
            this.dbType = "polardb-x";
        }
        catch (SQLException e) {
            this.dbType = "mysql";
        }
    }

    public void tableMetaRefreshEvent() {
        TableMetaCacheFactory.tableMetaRefreshEvent(this.getResourceId());
    }

    public Connection getPlainConnection() throws SQLException {
        return this.targetDataSource.getConnection();
    }

    public String getDbType() {
        return this.dbType;
    }

    @Override
    public ConnectionProxy getConnection() throws SQLException {
        Connection targetConnection = this.targetDataSource.getConnection();
        return new ConnectionProxy(this, targetConnection);
    }

    @Override
    public ConnectionProxy getConnection(String username, String password) throws SQLException {
        Connection targetConnection = this.targetDataSource.getConnection(username, password);
        return new ConnectionProxy(this, targetConnection);
    }

    @Override
    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    @Override
    public String getResourceId() {
        if (this.resourceId == null) {
            this.initResourceId();
        }
        return this.resourceId;
    }

    private void initResourceId() {
        if ("postgresql".equals(this.dbType)) {
            this.initPGResourceId();
        } else if ("oracle".equals(this.dbType) && this.userName != null) {
            this.initOracleResourceId();
        } else if ("mysql".equals(this.dbType) || "polardb-x".equals(this.dbType)) {
            this.initMysqlResourceId();
        } else if ("dm".equals(this.dbType)) {
            this.initDMResourceId();
        } else {
            this.initDefaultResourceId();
        }
    }

    private void initDefaultResourceId() {
        this.resourceId = this.jdbcUrl.contains("?") ? this.jdbcUrl.substring(0, this.jdbcUrl.indexOf(63)) : this.jdbcUrl;
    }

    private void initOracleResourceId() {
        this.resourceId = this.jdbcUrl.contains("?") ? this.jdbcUrl.substring(0, this.jdbcUrl.indexOf(63)) + "/" + this.userName : this.jdbcUrl + "/" + this.userName;
    }

    private void initMysqlResourceId() {
        String startsWith = "jdbc:mysql:loadbalance://";
        if (this.jdbcUrl.startsWith(startsWith)) {
            String url = this.jdbcUrl.contains("?") ? this.jdbcUrl.substring(0, this.jdbcUrl.indexOf(63)) : this.jdbcUrl;
            this.resourceId = url.replace(",", "|");
        } else {
            this.initDefaultResourceId();
        }
    }

    private void initPGResourceId() {
        if (this.jdbcUrl.contains("?")) {
            String[] urlParams;
            StringBuilder jdbcUrlBuilder = new StringBuilder();
            jdbcUrlBuilder.append(this.jdbcUrl, 0, this.jdbcUrl.indexOf(63));
            StringBuilder paramsBuilder = new StringBuilder();
            String paramUrl = this.jdbcUrl.substring(this.jdbcUrl.indexOf(63) + 1);
            for (String urlParam : urlParams = paramUrl.split("&")) {
                if (!urlParam.contains("currentSchema")) continue;
                if (urlParam.contains(",")) {
                    urlParam = urlParam.replace(",", "!");
                }
                paramsBuilder.append(urlParam);
                break;
            }
            if (paramsBuilder.length() > 0) {
                jdbcUrlBuilder.append("?");
                jdbcUrlBuilder.append((CharSequence)paramsBuilder);
            }
            this.resourceId = jdbcUrlBuilder.toString();
        } else {
            this.resourceId = this.jdbcUrl;
        }
    }

    private void initDMResourceId() {
        LOGGER.warn("support for the dameng database is currently an experimental feature ");
        if (this.jdbcUrl.contains("?")) {
            String[] urlParams;
            StringBuilder jdbcUrlBuilder = new StringBuilder();
            jdbcUrlBuilder.append(this.jdbcUrl, 0, this.jdbcUrl.indexOf(63));
            StringBuilder paramsBuilder = new StringBuilder();
            String paramUrl = this.jdbcUrl.substring(this.jdbcUrl.indexOf(63) + 1);
            for (String urlParam : urlParams = paramUrl.split("&")) {
                if (!urlParam.contains("schema")) continue;
                if (urlParam.contains("\"")) {
                    urlParam = urlParam.replaceAll("\"", "");
                }
                paramsBuilder.append(urlParam);
                break;
            }
            if (paramsBuilder.length() > 0) {
                jdbcUrlBuilder.append("?");
                jdbcUrlBuilder.append((CharSequence)paramsBuilder);
            }
            this.resourceId = jdbcUrlBuilder.toString();
        } else {
            this.resourceId = this.jdbcUrl;
        }
    }

    @Override
    public BranchType getBranchType() {
        return BranchType.AT;
    }

    public String getVersion() {
        return this.version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String selectDbVersion(Connection connection) {
        if (!"mysql".equals(this.dbType)) {
            if (!"polardb-x".equals(this.dbType)) return "";
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT VERSION()");
             ResultSet versionResult = preparedStatement.executeQuery();){
            if (!versionResult.next()) return "";
            String version = versionResult.getString("VERSION()");
            if (version == null) {
                String string = null;
                return string;
            }
            int dashIdx = version.indexOf(45);
            String string = dashIdx > 0 ? version.substring(0, dashIdx) : version;
            return string;
        }
        catch (Exception e) {
            LOGGER.error("get mysql version fail error: {}", (Object)e.getMessage());
        }
        return "";
    }
}

