/*
 * Decompiled with CFR 0.152.
 */
package io.seata.integration.rpc.core;

import io.seata.common.util.StringUtils;
import io.seata.core.context.RootContext;
import io.seata.integration.rpc.core.BaseRpcFilter;
import java.util.HashMap;
import java.util.Map;

public interface ConsumerRpcFilter<T>
extends BaseRpcFilter<T> {
    default public Map<String, String> getRootContexts() {
        HashMap<String, String> contextMap = new HashMap<String, String>();
        if (RootContext.inGlobalTransaction()) {
            block8: for (int i = 0; i < TRX_CONTEXT_KEYS.length; ++i) {
                switch (TRX_CONTEXT_KEYS[i]) {
                    case "TX_XID": {
                        this.assertNotNull(RootContext.getXID(), "xid is null");
                        contextMap.put("TX_XID", RootContext.getXID());
                        continue block8;
                    }
                    case "TX_BRANCH_TYPE": {
                        contextMap.put("TX_BRANCH_TYPE", RootContext.getBranchType().name());
                        continue block8;
                    }
                    default: {
                        throw new IllegalArgumentException("wrong context: " + TRX_CONTEXT_KEYS[i]);
                    }
                }
            }
        }
        return contextMap;
    }

    default public String getXidFromRootContexts(Map<String, String> rootContextMap) {
        return this.getValueFromMap(rootContextMap, "TX_XID");
    }

    default public void bindContextsToRequest(T rpcRequest, Map<String, String> contextMap) {
        for (int i = 0; i < TRX_CONTEXT_KEYS.length; ++i) {
            String contextValue = contextMap.get(TRX_CONTEXT_KEYS[i]);
            if (!StringUtils.isNotBlank(contextValue)) continue;
            this.bindContextToRequest(rpcRequest, TRX_CONTEXT_KEYS[i], contextValue);
        }
    }

    public void bindContextToRequest(T var1, String var2, String var3);

    default public void cleanRequestContexts(T rpcRequest, Map<String, String> contextMap) {
        for (int i = 0; i < TRX_CONTEXT_KEYS.length; ++i) {
            String contextValue = contextMap.get(TRX_CONTEXT_KEYS[i]);
            if (!StringUtils.isNotBlank(contextValue)) continue;
            this.cleanRequestContext(rpcRequest, TRX_CONTEXT_KEYS[i]);
        }
    }

    public void cleanRequestContext(T var1, String var2);
}

