/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.remoting.parser;

import io.seata.common.exception.FrameworkException;
import io.seata.integration.tx.api.remoting.RemotingDesc;
import io.seata.integration.tx.api.remoting.parser.AbstractedRemotingParser;
import io.seata.integration.tx.api.remoting.parser.DefaultRemotingParser;
import io.seata.spring.util.SpringProxyUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public class RemotingFactoryBeanParser
extends AbstractedRemotingParser {
    public ApplicationContext applicationContext;

    public RemotingFactoryBeanParser(ApplicationContext applicationContext) {
        Assert.notNull((Object)applicationContext, (String)"applicationContext must not be null");
        this.applicationContext = applicationContext;
    }

    protected Object getRemotingFactoryBean(Object bean, String beanName) {
        if (!SpringProxyUtils.isProxy(bean)) {
            return null;
        }
        String factoryBeanName = this.getFactoryBeanName(beanName);
        Object factoryBean = null;
        if (this.applicationContext.containsBean(factoryBeanName)) {
            factoryBean = this.applicationContext.getBean(factoryBeanName);
        }
        return factoryBean;
    }

    @Override
    public boolean isReference(Object bean, String beanName) {
        Object factoryBean = this.getRemotingFactoryBean(bean, beanName);
        if (factoryBean == null) {
            return false;
        }
        return DefaultRemotingParser.get().isReference(factoryBean, this.getFactoryBeanName(beanName));
    }

    @Override
    public boolean isService(Object bean, String beanName) {
        Object factoryBean = this.getRemotingFactoryBean(bean, beanName);
        if (factoryBean == null) {
            return false;
        }
        return DefaultRemotingParser.get().isService(factoryBean, this.getFactoryBeanName(beanName));
    }

    @Override
    public RemotingDesc getServiceDesc(Object bean, String beanName) throws FrameworkException {
        Object factoryBean = this.getRemotingFactoryBean(bean, beanName);
        if (factoryBean == null) {
            return null;
        }
        return DefaultRemotingParser.get().getServiceDesc(factoryBean, this.getFactoryBeanName(beanName));
    }

    private String getFactoryBeanName(String beanName) {
        return "&" + beanName;
    }

    @Override
    public short getProtocol() {
        return 0;
    }
}

