/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config;

import io.seata.common.exception.ShouldNeverHappenException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFuture {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigFuture.class);
    private static final long DEFAULT_CONFIG_TIMEOUT = 5000L;
    private long timeoutMills;
    private long start = System.currentTimeMillis();
    private String dataId;
    private String content;
    private ConfigOperation operation;
    private transient CompletableFuture<Object> origin = new CompletableFuture();

    public ConfigFuture(String dataId, String content, ConfigOperation operation) {
        this(dataId, content, operation, 5000L);
    }

    public ConfigFuture(String dataId, String content, ConfigOperation operation, long timeoutMills) {
        this.dataId = dataId;
        this.content = content;
        this.operation = operation;
        this.timeoutMills = timeoutMills;
    }

    public boolean isTimeout() {
        return System.currentTimeMillis() - this.start > this.timeoutMills;
    }

    public Object get() {
        return this.get(this.timeoutMills, TimeUnit.MILLISECONDS);
    }

    public Object get(long timeout, TimeUnit unit) {
        Object result;
        this.timeoutMills = unit.toMillis(timeout);
        try {
            result = this.origin.get(timeout, unit);
        }
        catch (ExecutionException e) {
            throw new ShouldNeverHappenException("Should not get results in a multi-threaded environment", (Throwable)e);
        }
        catch (TimeoutException e) {
            LOGGER.error("config operation timeout,cost:{} ms,op:{},dataId:{}", new Object[]{System.currentTimeMillis() - this.start, this.operation.name(), this.dataId});
            return this.getFailResult();
        }
        catch (InterruptedException exx) {
            LOGGER.error("config operate interrupted,error:{}", (Object)exx.getMessage(), (Object)exx);
            return this.getFailResult();
        }
        if (this.operation == ConfigOperation.GET) {
            return result == null ? this.content : result;
        }
        return result == null ? Boolean.FALSE : result;
    }

    private Object getFailResult() {
        if (this.operation == ConfigOperation.GET) {
            return this.content;
        }
        return Boolean.FALSE;
    }

    public void setResult(Object result) {
        this.origin.complete(result);
    }

    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public ConfigOperation getOperation() {
        return this.operation;
    }

    public void setOperation(ConfigOperation operation) {
        this.operation = operation;
    }

    public static enum ConfigOperation {
        GET,
        PUT,
        PUTIFABSENT,
        REMOVE;

    }
}

