/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.EventExecutorGroup;
import io.seata.common.exception.FrameworkErrorCode;
import io.seata.common.exception.FrameworkException;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.common.thread.RejectedPolicies;
import io.seata.common.util.NetUtil;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.core.protocol.AbstractMessage;
import io.seata.core.protocol.HeartbeatMessage;
import io.seata.core.protocol.RegisterTMRequest;
import io.seata.core.protocol.RegisterTMResponse;
import io.seata.core.protocol.ResultCode;
import io.seata.core.protocol.transaction.GlobalBeginResponse;
import io.seata.core.rpc.netty.AbstractRpcRemotingClient;
import io.seata.core.rpc.netty.NettyClientConfig;
import io.seata.core.rpc.netty.NettyPoolKey;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public final class TmRpcClient
extends AbstractRpcRemotingClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmRpcClient.class);
    private static volatile TmRpcClient instance;
    private static final int MAX_MERGE_SEND_THREAD = 1;
    private final ConcurrentMap<String, Object> channelLocks = new ConcurrentHashMap<String, Object>();
    private final ConcurrentMap<String, Channel> channels = new ConcurrentHashMap<String, Channel>();
    private static final Configuration CONFIG;
    private static final long KEEP_ALIVE_TIME = Integer.MAX_VALUE;
    private static final int MAX_QUEUE_SIZE = 2000;
    private static final String MERGE_THREAD_PREFIX = "rpcMergeMessageSend";
    private static final int SCHEDULE_INTERVAL_MILLS = 5;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private String applicationId;
    private String transactionServiceGroup;
    private final NettyClientConfig tmClientConfig;
    private final ConcurrentMap<String, NettyPoolKey> poolKeyMap = new ConcurrentHashMap<String, NettyPoolKey>();
    public static boolean enableDegrade;

    private TmRpcClient(NettyClientConfig nettyClientConfig, EventExecutorGroup eventExecutorGroup, ThreadPoolExecutor messageExecutor) {
        super(nettyClientConfig, eventExecutorGroup, messageExecutor);
        this.tmClientConfig = nettyClientConfig;
    }

    public static TmRpcClient getInstance(String applicationId, String transactionServiceGroup) {
        TmRpcClient tmRpcClient = TmRpcClient.getInstance();
        tmRpcClient.setApplicationId(applicationId);
        tmRpcClient.setTransactionServiceGroup(transactionServiceGroup);
        return tmRpcClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TmRpcClient getInstance() {
        if (null != instance) return instance;
        Class<TmRpcClient> clazz = TmRpcClient.class;
        synchronized (TmRpcClient.class) {
            if (null != instance) return instance;
            NettyClientConfig nettyClientConfig = new NettyClientConfig();
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(nettyClientConfig.getClientWorkerThreads(), nettyClientConfig.getClientWorkerThreads(), Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(2000), (ThreadFactory)new NamedThreadFactory(nettyClientConfig.getTmDispatchThreadPrefix(), nettyClientConfig.getClientWorkerThreads()), RejectedPolicies.runsOldestTaskPolicy());
            instance = new TmRpcClient(nettyClientConfig, null, threadPoolExecutor);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void init() {
        if (this.initialized.compareAndSet(false, true)) {
            this.init(5L, 5L);
        }
    }

    private void initVars() {
        enableDegrade = CONFIG.getBoolean("service.enableDegrade");
        super.init();
    }

    public void init(long healthCheckDelay, long healthCheckPeriod) {
        this.initVars();
        ThreadPoolExecutor mergeSendExecutorService = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory(this.getThreadPrefix(MERGE_THREAD_PREFIX), 1));
        mergeSendExecutorService.submit(new AbstractRpcRemotingClient.MergedSendRunnable());
        this.timerExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    TmRpcClient.this.reconnect(TmRpcClient.this.transactionServiceGroup);
                }
                catch (Exception ignore) {
                    LOGGER.error(ignore.getMessage());
                }
            }
        }, healthCheckDelay, healthCheckPeriod, TimeUnit.SECONDS);
    }

    @Override
    public Object sendMsgWithResponse(Object msg, long timeout) throws TimeoutException {
        Channel acquireChannel;
        String validAddress = this.loadBalance(this.transactionServiceGroup);
        Object result = super.sendAsyncRequestWithResponse(validAddress, acquireChannel = this.connect(validAddress), msg, timeout);
        if (result instanceof GlobalBeginResponse && ((GlobalBeginResponse)result).getResultCode() == ResultCode.Failed) {
            LOGGER.error("begin response error,release channel:" + acquireChannel);
            this.releaseChannel(acquireChannel, validAddress);
        }
        return result;
    }

    @Override
    public Object sendMsgWithResponse(Object msg) throws TimeoutException {
        return this.sendMsgWithResponse(msg, NettyClientConfig.getRpcRequestTimeout());
    }

    @Override
    public Object sendMsgWithResponse(String serverAddress, Object msg, long timeout) throws TimeoutException {
        return this.sendAsyncRequestWithResponse(serverAddress, this.connect(serverAddress), msg, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent idleStateEvent = (IdleStateEvent)evt;
            if (idleStateEvent.state() == IdleState.READER_IDLE) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("channel" + ctx.channel() + " read idle.");
                }
                try {
                    this.nettyClientKeyPool.invalidateObject(this.poolKeyMap.get(ctx.channel().remoteAddress()), (Object)ctx.channel());
                }
                catch (Exception exx) {
                    LOGGER.error(exx.getMessage());
                }
                finally {
                    this.releaseChannel(ctx.channel(), this.getAddressFromContext(ctx));
                }
            }
            if (idleStateEvent == IdleStateEvent.WRITER_IDLE_STATE_EVENT) {
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("will send ping msg,channel" + ctx.channel());
                    }
                    this.sendRequest(ctx.channel(), HeartbeatMessage.PING);
                }
                catch (Throwable throwable) {
                    LOGGER.error("", (Object)"send request error", (Object)throwable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void releaseChannel(Channel channel, String serverAddress) {
        if (null == channel || null == serverAddress) {
            return;
        }
        try {
            Object connectLock;
            Object v = connectLock = this.channelLocks.get(serverAddress);
            synchronized (v) {
                Channel ch = (Channel)this.channels.get(serverAddress);
                if (null == ch) {
                    this.nettyClientKeyPool.returnObject(this.poolKeyMap.get(serverAddress), (Object)channel);
                    return;
                }
                if (ch.compareTo((Object)channel) == 0) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("return to pool, tm channel:" + channel);
                    }
                    this.destroyChannel(serverAddress, channel);
                } else {
                    this.nettyClientKeyPool.returnObject(this.poolKeyMap.get(serverAddress), (Object)channel);
                }
            }
        }
        catch (Exception exx) {
            LOGGER.error(exx.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Channel connect(String serverAddress) {
        Object connectLock;
        Channel channelToServer = (Channel)this.channels.get(serverAddress);
        if (null != channelToServer && null != (channelToServer = this.getExistAliveChannel(channelToServer, serverAddress))) {
            return channelToServer;
        }
        this.channelLocks.putIfAbsent(serverAddress, new Object());
        Object v = connectLock = this.channelLocks.get(serverAddress);
        synchronized (v) {
            channelToServer = this.doConnect(serverAddress);
            this.channels.put(serverAddress, channelToServer);
            return channelToServer;
        }
    }

    private Channel getExistAliveChannel(Channel channel, String serverAddress) {
        int i;
        if (channel.isActive()) {
            return channel;
        }
        for (i = 0; i < NettyClientConfig.getMaxCheckAliveRetry(); ++i) {
            try {
                Thread.sleep(NettyClientConfig.getCheckAliveInternal());
            }
            catch (InterruptedException exx) {
                LOGGER.error(exx.getMessage());
            }
            channel = (Channel)this.channels.get(serverAddress);
            if (null != channel && !channel.isActive()) continue;
            return channel;
        }
        if (i == NettyClientConfig.getMaxCheckAliveRetry()) {
            LOGGER.warn("channel " + channel + " is not active after long wait, close it.");
            this.releaseChannel(channel, serverAddress);
            return null;
        }
        return null;
    }

    @Override
    protected GenericKeyedObjectPool.Config getNettyPoolConfig() {
        GenericKeyedObjectPool.Config poolConfig = new GenericKeyedObjectPool.Config();
        poolConfig.maxActive = this.tmClientConfig.getMaxPoolActive();
        poolConfig.minIdle = this.tmClientConfig.getMinPoolIdle();
        poolConfig.maxWait = this.tmClientConfig.getMaxAcquireConnMills();
        poolConfig.testOnBorrow = this.tmClientConfig.isPoolTestBorrow();
        poolConfig.testOnReturn = this.tmClientConfig.isPoolTestReturn();
        poolConfig.lifo = this.tmClientConfig.isPoolLifo();
        return poolConfig;
    }

    @Override
    protected NettyPoolKey.TransactionRole getTransactionRole() {
        return NettyPoolKey.TransactionRole.TMROLE;
    }

    private Channel doConnect(String serverAddress) {
        Channel channelToServer = (Channel)this.channels.get(serverAddress);
        if (null != channelToServer && channelToServer.isActive()) {
            return channelToServer;
        }
        try {
            RegisterTMRequest registerTransactionManagerRequest = new RegisterTMRequest(this.applicationId, this.transactionServiceGroup);
            this.poolKeyMap.putIfAbsent(serverAddress, new NettyPoolKey(this.getTransactionRole(), serverAddress, registerTransactionManagerRequest));
            channelToServer = (Channel)this.nettyClientKeyPool.borrowObject(this.poolKeyMap.get(serverAddress));
        }
        catch (Exception exx) {
            LOGGER.error("get channel from pool error.", (Throwable)exx);
            throw new FrameworkException("can not register TM,err:" + exx.getMessage());
        }
        return channelToServer;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getTransactionServiceGroup() {
        return this.transactionServiceGroup;
    }

    public void setTransactionServiceGroup(String transactionServiceGroup) {
        this.transactionServiceGroup = transactionServiceGroup;
    }

    @Override
    public void sendResponse(long msgId, String serverAddress, Object msg) {
        super.sendResponse(msgId, this.connect(serverAddress), msg);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOGGER.error(FrameworkErrorCode.ExceptionCaught.errCode, (Object)(NetUtil.toStringAddress((SocketAddress)ctx.channel().remoteAddress()) + "connect exception. " + cause.getMessage()), (Object)cause);
        this.releaseChannel(ctx.channel(), this.getAddressFromChannel(ctx.channel()));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("remove exception rm channel:" + ctx.channel());
        }
        super.exceptionCaught(ctx, cause);
    }

    @Override
    public void onRegisterMsgSuccess(String serverAddress, Channel channel, Object response, AbstractMessage requestMessage) {
        if (null != this.channels.get(serverAddress) && ((Channel)this.channels.get(serverAddress)).isActive()) {
            return;
        }
        this.channels.put(serverAddress, channel);
    }

    @Override
    public void onRegisterMsgFail(String serverAddress, Channel channel, Object response, AbstractMessage requestMessage) {
        if (response instanceof RegisterTMResponse && LOGGER.isInfoEnabled()) {
            LOGGER.info("register client failed, server version:" + ((RegisterTMResponse)response).getVersion());
        }
        throw new FrameworkException("register client app failed.");
    }

    @Override
    public void destroyChannel(String serverAddress, Channel channel) {
        if (null == channel) {
            return;
        }
        try {
            if (channel.equals(this.channels.get(serverAddress))) {
                this.channels.remove(serverAddress);
            }
            this.nettyClientKeyPool.returnObject(this.poolKeyMap.get(serverAddress), (Object)channel);
        }
        catch (Exception exx) {
            LOGGER.error("return channel to rpcPool error:" + exx.getMessage());
        }
    }

    static {
        CONFIG = ConfigurationFactory.getInstance();
        enableDegrade = false;
    }
}

