/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.protocol;

import io.netty.buffer.ByteBuf;
import io.seata.core.protocol.AbstractMessage;
import io.seata.core.protocol.MergedMessage;
import io.seata.core.protocol.ResultCode;
import java.nio.ByteBuffer;

public abstract class AbstractResultMessage
extends AbstractMessage
implements MergedMessage {
    private static final long serialVersionUID = 6540352050650203313L;
    private ResultCode resultCode;
    public ByteBuffer byteBuffer = ByteBuffer.allocate(512);
    private String msg;

    public ResultCode getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(ResultCode resultCode) {
        this.resultCode = resultCode;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    protected void doEncode() {
        this.byteBuffer.put((byte)this.resultCode.ordinal());
        if (this.resultCode == ResultCode.Failed) {
            if (this.getMsg() != null) {
                String msg = this.getMsg().length() > 128 ? this.getMsg().substring(0, 128) : this.getMsg();
                byte[] bs = msg.getBytes(UTF8);
                if (bs.length > 400 && this.getMsg().length() > 64) {
                    msg = this.getMsg().substring(0, 64);
                    bs = msg.getBytes(UTF8);
                }
                this.byteBuffer.putShort((short)bs.length);
                if (bs.length > 0) {
                    this.byteBuffer.put(bs);
                }
            } else {
                this.byteBuffer.putShort((short)0);
            }
        }
    }

    private final byte[] flushEncode() {
        this.byteBuffer.flip();
        byte[] content = new byte[this.byteBuffer.limit()];
        this.byteBuffer.get(content);
        this.byteBuffer.clear();
        return content;
    }

    @Override
    public final byte[] encode() {
        this.doEncode();
        return this.flushEncode();
    }

    @Override
    public void decode(ByteBuffer byteBuffer) {
        short len;
        this.setResultCode(ResultCode.get(byteBuffer.get()));
        if (this.resultCode == ResultCode.Failed && (len = byteBuffer.getShort()) > 0) {
            byte[] msg = new byte[len];
            byteBuffer.get(msg);
            this.setMsg(new String(msg, UTF8));
        }
    }

    @Override
    public boolean decode(ByteBuf in) {
        if (in.readableBytes() < 1) {
            return false;
        }
        this.setResultCode(ResultCode.get(in.readByte()));
        if (this.resultCode == ResultCode.Failed) {
            if (in.readableBytes() < 2) {
                return false;
            }
            short len = in.readShort();
            if (in.readableBytes() < len) {
                return false;
            }
            if (len > 0) {
                byte[] msg = new byte[len];
                in.readBytes(msg);
                this.setMsg(new String(msg, UTF8));
            }
        }
        return true;
    }
}

